% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2d.R
\name{find_pts}
\alias{find_pts}
\title{Find points in hexagonal bins}
\usage{
find_pts(data_hex_id)
}
\arguments{
\item{data_hex_id}{A data frame with data, ID and hexagonal bin IDs.}
}
\value{
A data frame with hexagonal bin IDs and the corresponding points.
}
\description{
This function maps points to their corresponding hexagonal bins.
}
\examples{
num_bins_list <- calc_bins(data = s_curve_noise_umap_scaled, x = "UMAP1",
y = "UMAP2", hex_size = NA, buffer_x = NA, buffer_y = NA)
num_bins_x <- num_bins_list$num_x
num_bins_y <- num_bins_list$num_y
centroid_list <- gen_centroids(data = s_curve_noise_umap_scaled,
x = "UMAP1", y = "UMAP2", num_bins_x = num_bins_x,
num_bins_y = num_bins_y, x_start = NA, y_start = NA, buffer_x = NA,
buffer_y = NA, hex_size = NA)
all_centroids_df <- as.data.frame(do.call(cbind, centroid_list))
s_curve_noise_umap_scaled_rm_id <- s_curve_noise_umap_scaled |> dplyr::select(-ID)
nldr_with_hb_id_list <- assign_data(data = s_curve_noise_umap_scaled_rm_id,
centroid_df = all_centroids_df, col_start = "UMAP")
umap_with_hb_id <- as.data.frame(do.call(cbind, nldr_with_hb_id_list))
umap_with_hb_id <- umap_with_hb_id |> dplyr::mutate(ID = s_curve_noise_umap_scaled$ID)
find_pts(data_hex_id = umap_with_hb_id)

}
