% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_scores.R
\name{get_scores}
\alias{get_scores}
\title{Get PGS Catalog Scores}
\usage{
get_scores(
  pgs_id = NULL,
  efo_id = NULL,
  pubmed_id = NULL,
  set_operation = "union",
  interactive = TRUE,
  verbose = FALSE,
  warnings = TRUE,
  progress_bar = TRUE
)
}
\arguments{
\item{pgs_id}{A \code{character} vector of PGS Catalog score accession
identifiers.}

\item{efo_id}{A character vector of \href{https://www.ebi.ac.uk/efo/}{EFO}
identifiers.}

\item{pubmed_id}{An \code{integer} vector of
\href{https://en.wikipedia.org/wiki/PubMed}{PubMed} identifiers.}

\item{set_operation}{Either \code{'union'} or \code{'intersection'}. This
tells how scores retrieved by different criteria  should be combined:
\code{'union'} binds together all results removing duplicates and
\code{'intersection'} only keeps same scores found with different
criteria.}

\item{interactive}{A logical. If all scores are requested, whether to ask
interactively if we really want to proceed.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if any.}

\item{progress_bar}{Whether to show a progress bar as the queries are
performed.}
}
\value{
A \linkS4class{scores} object.
}
\description{
Retrieves polygenic scores via the PGS Catalog REST API. The REST
API is queried multiple times with the criteria passed as arguments (see
below). By default all scores that match the criteria supplied in the
arguments are retrieved: this corresponds to the default option
\code{set_operation} set to \code{'union'}. If you rather have only the
associations that match simultaneously all criteria provided, then set
\code{set_operation} to \code{'intersection'}.
}
\details{
Please note that all search criteria are vectorised, thus allowing for batch
mode search.
}
\examples{
\dontrun{
# By `pgs_id`
get_scores(pgs_id = 'PGS000088')

# By `efo_id`
get_scores(efo_id = 'EFO_0007992')

# By `pubmed_id`
get_scores(pubmed_id = '25748612')
}
}
