% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equations1.R
\name{geo.cv}
\alias{geo.cv}
\alias{geo.mean}
\alias{geo.sd}
\title{Calculate geometric coefficient of variation, mean, or SD and round}
\usage{
geo.cv(num, round = 2, na.rm = TRUE, neg.rm = TRUE, pct = TRUE)

geo.mean(num, round = 2, na.rm = TRUE, neg.rm = TRUE)

geo.sd(num, round = 2, na.rm = TRUE, neg.rm = TRUE)
}
\arguments{
\item{num}{vector of numbers}

\item{round}{round result to decimal place}

\item{na.rm}{remove NAs from the vector}

\item{neg.rm}{remove negative values from the vector}

\item{pct}{TRUE or FALSE. should result be in percent}
}
\value{
the geometric cv of a set of numbers

the geometric mean of a set of numbers

the geometric standard deviation of a set of numbers
}
\description{
Calculate the coefficient of variation

Calculate the geometric mean

Calculate the geometric standard deviation
}
\examples{
#simulate numbers using a fixed seed
num1 <- number(n = 1115,max.digits = 4, seed = 10)

#get geometric CV, represent as percent and round to 2 decimal places
geo.cv(num1,round = 2) # result: 60.61\%

#or round to 3 decimal places
geo.cv(num1,round = 3) # result: 60.609\%

#by default, the above examples return a CV\%
#if you do not want the result as percentage, specify "pct"
geo.cv(num1,pct = FALSE) # result: 0.61

num1 <- sample(300:3000,10)

#get the geometric mean, excluding all negatives and round to 2
geo.mean(num1)

#or
geo.mean(num1)


#get geometric mean, but round the final value to 5 decimal places
geo.mean(num1, round = 5)

num1 <- sample(330:400,20)

#get geometric SD remove negative values and round to 2 decimal places
geo.sd(num1)

#get geometric SD, DON'T remove negative values and round to 2 decimal places
geo.sd(num1,na.rm=FALSE)

#get geometric SD, remove negative values and round to 3 decimal places
geo.sd(num1,round = 3)

}
