% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{scores}
\alias{scores}
\title{Observed Unweighted Scoring of Multiple Sets of Variables/Items}
\usage{
scores(
  data,
  vrb.nm.list,
  avg = TRUE,
  ov.min = 1,
  prop = TRUE,
  inclusive = TRUE,
  impute = TRUE,
  std = FALSE,
  std.data = std,
  std.score = std
)
}
\arguments{
\item{data}{data.frame or numeric/logical matrix}

\item{vrb.nm.list}{list where each element is a character vector of colnames
in \code{data} specifying the variables/items for that score. The names  of
\code{vrb.nm.list} will be the names of the scores in the return object.}

\item{avg}{logical vector of length 1 specifying whether mean scores (TRUE)
or sum scores (FALSE) should be created.}

\item{ov.min}{minimum frequency of observed values required per row. If
\code{prop} = TRUE, then this is a decimal between 0 and 1. If \code{prop}
= FALSE, then this is a integer between 0 and
\code{length(vrb.nm.list[[i]])}.}

\item{prop}{logical vector of length 1 specifying whether \code{ov.min}
should refer to the proportion of observed values (TRUE) or the count of
observed values (FALSE). If the multiple sets of variables/items contain
different numbers of variables, it probably makes the most sense to use the
proportion of observed values (TRUE).}

\item{inclusive}{logical vector of length 1 specifying whether the scores
should be calculated (rather than NA) if the frequency of observed values
in a row is exactly equal to \code{ov.min}.}

\item{impute}{logical vector of length 1 specifying if missing values should
be imputed with the mean of observed values from each row of
\code{data[vrb.nm.list[[i]] ]} (i.e., row mean imputation). If TRUE
(default), this will make sums over the same rows with different
frequencies of missing values comparable. Note, this argument is only used
when \code{avg} = FALSE since when \code{avg} = TRUE row mean imputation is
always done implicitly.}

\item{std}{logical vector of length 1 specifying whether 1) the variables
should be standardized before scoring and 2) the score standardized after
creation. This argument is for convenience as these two standardization
processes are often used together. However, this argument will be
overwritten by any non-default value for \code{std.data} and
\code{std.score}.}

\item{std.data}{logical vector of length 1 specifying whether the
variables/items should be standardized before scoring.}

\item{std.score}{logical vector of length 1 specifying whether the scores
should be standardized after creation.}
}
\value{
data.frame of mean/sum scores with \code{NA} for any row with the
  frequency of observed values less than (or equal to) \code{ov.min}. The
  colnames are specified by \code{names(vrb.nm.list)} and rownames by
  \code{row.names(data)}.
}
\description{
\code{scores} calculates observed unweighted scores across multiple sets of
variables/items. If a row's frequency of observed data is less than (or equal
to) \code{ov.min}, then NA is returned for that row. Each set of
variables/items are coerced to a matrix before scoring. If the coercion leads
to a character matrix, an error is returned. This can be tested with
\code{lapply(X = vrb.nm.list, FUN = function(nm)
is.character(as.matrix(data[nm])))}.
}
\examples{
list_colnames <- list("first" = c("rating","complaints","privileges"),
    "second" = c("learning","raises","critical"))
scores(data = attitude, vrb.nm.list = list_colnames)
list_colnames <- list("first" = c("Ozone","Wind"),
    "second" = c("Solar.R","Temp"))
scores(data = airquality, vrb.nm.list = list_colnames, ov.min = .50,
   inclusive = FALSE) # scoring conditional on observed values
}
\seealso{
\code{\link{score}}
   \code{\link{rowMeans_if}}
   \code{\link{rowSums_if}}
   \code{\link[psych]{scoreItems}}
}
