% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{recode2other}
\alias{recode2other}
\title{Recode Unique Values in a Character Vector to 0ther (or NA)}
\usage{
recode2other(
  x,
  freq.min,
  prop = FALSE,
  inclusive = TRUE,
  other.nm = "other",
  extra.nm = NULL
)
}
\arguments{
\item{x}{character vector. If not a character vector, it will be coarced to
one via \code{as.character}.}

\item{freq.min}{numeric vector of length 1 specifying the minimum frequency
of a unique value to keep it unchanged and consequentially recode any
unique values with frequencues less than (or equal to) it.}

\item{prop}{logical vector of length 1 specifying if \code{freq.min} provides
the frequency as a count (FALSE) or proportion (TRUE).}

\item{inclusive}{logical vector of length 1 specifying whether the frequency
of a unique value exactly equal to \code{freq.min} should be kept unchanged
(and not recoded to \code{other.nm}).}

\item{other.nm}{character vector of length 1 specifying what value the other
unique values should be recoded to. This can be NA_character_ resulting in
recoding to a missing value.}

\item{extra.nm}{character vector specifying extra unique values that should
be recoded to \code{other.nm} that are not included based on the minimum
frequency from the combination of \code{freq.min}, \code{prop},
\code{inclusive}. The default is NULL, meaning no extra unique values are
recoded.}
}
\value{
character vector of the same length as \code{x} with unique values
  with frequency less than \code{freq.nm} recoded to \code{other.nm} as well
  as any unique values in \code{extra.nm}. While the current version of the
  function allows for recoding *to* NA values via \code{other.nm}, it does
  not allow for recoding *from* NA values via \code{extra.nm} (see examples).
}
\description{
\code{recode2other} recodes multiple unique values in a character vector to
the same new value (e.g., "other", NA_character_). It's primary use is to
recode based on the minimum frequency of the unique values so that low
frequency values can be combined into the same category; however, it also
allows for recoding particular unique values given by the user (see details).
This function is a wrapper for \code{car::recode}, which can handle general
recoding of character vectors.
}
\details{
The \code{extra.nm} argument allows for \code{recode2other} to be used as
simpler function that just recodes particular unique values to the same new
value (although arguably this is easier to do using \code{car::recode}
directly). To do so set \code{freq.min = 0} and provide the unique values to
\code{extra.nm}. Note, that the current version of this function does not
allow for NA_character_ to be included in \code{extra.nm} as it will end up
treating it as "NA" (see examples).
}
\examples{

# based on minimum frequency unique values
state_region <- as.character(state.region)
recode2other(state_region, freq.min = 13) # freq.min as a count
recode2other(state_region, freq.min = 0.26, prop = TRUE) # freq.min as a proportion
recode2other(state_region, freq.min = 13, other.nm = "_blank_")
recode2other(state_region, freq.min = 13,
   other.nm = NA) # allows for other.nm to be NA
recode2other(state_region, freq.min = 13,
   extra.nm = "South") # add an extra unique value to recode
recode2other(state_region, freq.min = 13,
   inclusive = FALSE) # recodes "West" to "other"

# based on user given unique values
recode2other(state_region, freq.min = 0,
   extra.nm = c("South","West")) # recodes manually rather than by freq.min
# current version does NOT allow for NA to be a unique value that is converted to other
state_region2 <- c(NA, state_region, NA)
recode2other(state_region2, freq.min = 13) # NA remains in the character vector
recode2other(state_region2, freq.min = 0,
   extra.nm = c("South","West",NA)) # NA remains in the character vector

}
\seealso{
\code{\link[car]{recode}}
   \code{\link{ifelse}}
}
