% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\docType{package}
\name{quest-package}
\alias{quest}
\alias{quest-package}
\title{Pre-processing Questionnaire Data}
\description{
\code{quest} is a package for pre-processing questionnaire data
  to get it ready for statistical modeling. It contains functions for
  investigating missing data (e.g., \code{\link{rowNA}}), reshaping data
  (e.g., \code{\link{wide2long}}), validating responses (e.g.,
  \code{\link{revalids}}), recoding variables (e.g., \code{\link{recodes}}),
  scoring (e.g., \code{\link{scores}}), centering (e.g.,
  \code{\link{centers}}), aggregating (e.g., \code{\link{aggs}}), shifting
  (e.g., \code{\link{shifts}}), etc. Functions whose first phrases end with
  an \code{s} are vectorized versions of their functions without an \code{s}
  at the end of the first phrase. For example, \code{center} inputs a
  (atomic) vector and outputs a atomic vector to center and/or scale a single
  variable; \code{centers} inputs a data.frame and outputs a data.frame to
  center and/or scale multiple variables. Functions that end in \code{_by}
  are calculated by group. For example, \code{center} does grand-mean
  centering while \code{center_by} does group-mean centering. Putting the two
  together, \code{centers_by} inputs a data.frame and outputs a data.frame to
  center and/or scale multiple variables by group. Functions that end in
  \code{_ml} calculate a "multilevel" result with a within-group result and
  between-group result. Functions that end in \code{_if} are calculated
  dependent on the frequency of observed values (aka amount of missing data).
  The \code{quest} package uses the \code{str2str} package internally to
  convert R objects from one structure to another. See \code{\link{str2str}}
  for details.
}
\section{Types of functions}{
 There are three main types of functions. 1)
  Helper functions that primarily exist to save a few lines of code and are
  primarily for convenience (e.g., \code{\link{vecNA}}). 2) Functions for
  wrangling questionnaire data (e.g., \code{\link{nom2dum}},
  \code{\link{reverses}}). 3) Functions for preliminary statistical
  calculation (e.g., \code{\link{means_diff}}, \code{\link{corp_by}}).
}

\section{Abbreviations}{
 See the table below

\describe{
   \item{vrb}{variable}
   \item{grp}{group}
   \item{nm}{names}
   \item{NA}{missing values}
   \item{ov}{observed values}
   \item{prop}{proportion}
   \item{sep}{separator}
   \item{cor}{correlations}
   \item{id}{identifier}
   \item{rtn}{return}
   \item{fun}{function}
   \item{dfm}{data.frame}
   \item{fct}{factor}
   \item{nom}{nominal variable}
   \item{bin}{binary variable}
   \item{dum}{dummy variable}
   \item{pomp}{percentage of maximum possible}
   \item{std}{standardize}
   \item{wth}{within-groups}
   \item{btw}{between-groups}
}
}

\author{
\strong{Maintainer}: David Disabato \email{ddisab01@gmail.com} (\href{https://orcid.org/0000-0001-7094-4996}{ORCID})

}
