#'CCQ Q-set criteria scores and derived scales
#'
#'A data frame containing the California Child Q-set (ccq). 
#'In this dataset, column names ending in "_c" refer to criteria 
#'sorts' scores, while column names ending in "_s" refer to
#'scales' scores.
#'
#'@format CCQ dataset with 100 rows (items) and 6 columns.
#'  \describe{
#'    \item{item}{Item number from 1 to 100.}
#'    \item{qset}{ccq. California Child Q-set (Block & Block, 1969).}
#'    \item{scomp_c}{Social competence criterion scores
#'    (retrieved from Waters et al., 1985).}
#'    \item{sest_c}{Self-esteem criterion scores
#'    (retrieved from Waters et al., 1985).}
#'    \item{sest_c}{Self-esteem criterion scores
#'    (retrieved from Waters et al., 1985).}
#'    \item{egores_c}{Ego-resiliency criterion scores (Block & Block, 1980;
#'    retrieved from Brian Vaughn, personal communication).}
#'    \item{egocont_c}{Ego-control criterion scores (Block & Block, 1980;
#'    retrieved from Brian Vaughn, personal communication).}
#'    \item{shields_s}{Emotion regulation scale
#'    (retrieved from Shields and Cicchetti, 1997)}
#'    \item{shields_s_inv}{Items to be inverted in emotion regulation scale.}
#'    \item{description}{Item description (retrieved from Waters et al., 1985).}} 
#'
#'@references Block, J. H., & Block, J. (1969). The California Child Q-Set. Berkeley, CA:
#'  Institute of Human Development, University of California.
#'
#'  Block, J. H., & Block, J. (1980). The role of ego-control and ego-resiliency
#'  in the organization of behavior. In W. A. Collins (Ed.), Minnesota symposium
#'  on child psychology: Vol. 13. Development of cognition affect, and social
#'  relations (pp. 39–101), Hillsdale, NJ: Erlbaum.
#'  
#'  Shields, A., & Cicchetti, D. (1997). Emotion regulation among school-age
#'  children: The development and validation of a new criterion q-sort scale.
#'  Developmental Psychology, 33, 906-916.
#'  
#'  Waters, E., Noyes, D. M., Vaughn, B. E., & Ricks, M. (1985). Q-sort
#'  definitions of social competence and self-esteem: Discriminant validity of
#'  related constructs in theory and data. Developmental Psychology, 21,
#'  508-522.
#'  
"qset_ccq"