% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.corr.r
\name{tab.corr}
\alias{tab.corr}
\title{Tabulate Corrections}
\usage{
tab.corr(x, by = character(0), nomtimevar = "time")
}
\arguments{
\item{x}{concentration dataset created by the correct.time and correct.conc functions, containing time and conc corrected data}

\item{by}{column names in x indicating grouping variables}

\item{nomtimevar}{column in x containing the nominal time after dose}
}
\value{
dataset with applied corrections (rule number and rule text) listed by by-variable(s) and nominal time
}
\description{
Tabulates what records were added, time deviations and
concentration imputations were applied, for each subject.
}
\examples{
\donttest{
example(correct.conc)
corrtab <- x \%>\% tab.corr(by = 'subject')
corrtab \%>\% head
}
}
