% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.1.R
\name{sqdft.fit}
\alias{sqdft.fit}
\title{Spline Quantile Discrete Fourier Transform (SQDFT) of Time Series Given Smoothing Parameter}
\usage{
sqdft.fit(
  y,
  tau,
  spar = 1,
  d = 1,
  weighted = FALSE,
  ztol = 1e-05,
  n.cores = 1,
  cl = NULL
)
}
\arguments{
\item{y}{vector or matrix of time series (if matrix, \code{nrow(y)} = length of time series)}

\item{tau}{sequence of quantile levels in (0,1)}

\item{spar}{smoothing parameter}

\item{d}{subsampling rate of quantile levels (default = 1)}

\item{weighted}{if \code{TRUE}, penalty function is weighted (default = \code{FALSE})}

\item{ztol}{zero tolerance parameter used to determine the effective dimensionality of the fit}

\item{n.cores}{number of cores for parallel computing (default = 1)}

\item{cl}{pre-existing cluster for repeated parallel computing (default = \code{NULL})}
}
\value{
A list with the following elements:
  \item{coefficients}{matrix of regression coefficients}
  \item{qdft}{matrix or array of the spline quantile discrete Fouror BICier transform of \code{y}}
  \item{crit}{criteria for smoothing parameter selection: (AIC,BIC)}
}
\description{
This function computes spline quantile discrete Fourier transform (SQDFT) for univariate or multivariate time series
through trigonometric spline quantile regression with user-supplied spar.
}
\examples{
y <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
tau <- seq(0.1,0.9,0.05)
y.sqdft <- sqdft.fit(y,tau,spar=1,d=4)$qdft
}
