% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa2.1.R
\name{tsqr.fit}
\alias{tsqr.fit}
\title{Trigonometric Spline Quantile Regression (TSQR)}
\usage{
tsqr.fit(y, f0, tau, c0, d = 1, weighted = FALSE, prepared = TRUE)
}
\arguments{
\item{y}{vector of time series}

\item{f0}{frequency in [0,1)}

\item{tau}{sequence of quantile levels in (0,1)}

\item{c0}{penalty parameter}

\item{d}{subsampling rate of quantile levels (default = 1)}

\item{weighted}{if \code{TRUE}, penalty function is weighted (default = \code{FALSE})}

\item{prepared}{if \code{TRUE}, intercept is removed and coef of cosine is doubled when \code{f0 = 0.5}}
}
\value{
object of \code{sqr.fit()} (coefficients in \code{$coef})
}
\description{
This function computes trigonometric spline quantile regression (TSQR) for univariate time series at a single frequency.
}
\examples{
y <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
tau <- seq(0.1,0.9,0.05)
fit <- tqr.fit(y,f0=0.1,tau=tau)
fit.sqr <- tsqr.fit(y,f0=0.1,tau=tau,c0=0.02,d=4)
plot(tau,fit$coef[1,],type='p',xlab='QUANTILE LEVEL',ylab='TQR COEF')
lines(tau,fit.sqr$coef[1,],type='l')
}
