% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medserial_paths.R
\name{medserial_paths}
\alias{medserial_paths}
\title{Compute Power for Serial Mediation Effects
Requires correlations between all variables as sample size.
This approach calculates power for the serial mediation using
joint significance (recommended) and path coefficients}
\usage{
medserial_paths(a1, a2, b1, b2, d, cprime, n, alpha = 0.05, reps = 1000)
}
\arguments{
\item{a1}{path between predictor and first mediator}

\item{a2}{path between predictor and first mediator}

\item{b1}{Path between first mediator and dependent variable}

\item{b2}{Path between first mediator and dependent variable}

\item{d}{Path first mediator (m1) and second mediator (m2)}

\item{cprime}{Path between predictor and dependent variable}

\item{n}{Sample size}

\item{alpha}{Type I error (default is .05)}

\item{reps}{number of repetitions (1000 is default)}
}
\value{
Power for Serial Mediated (Indirect) Effects
}
\description{
Compute Power for Serial Mediation Effects
Requires correlations between all variables as sample size.
This approach calculates power for the serial mediation using
joint significance (recommended) and path coefficients
}
\examples{
\donttest{medserial_paths(a1=.3, a2=.3, b1=.35,
b2=.3,d=.2,cprime=.1,n=150)}
}
