% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_features.R
\name{prep_grid}
\alias{prep_grid}
\title{Creates vector grid cells over study area}
\usage{
prep_grid(outline, size, clip_level = 0, point_over = NULL, point_n = 0)
}
\arguments{
\item{outline}{SpatialPolygon or SpatialPolygonDataFrame that defines the area to draw grid cells over}

\item{size}{scaler for the size of the grid cells (one side), in whatever units the outline is in}

\item{clip_level}{, you can clip grid cells if they are not entirely inside the outlined area, defaults to \code{0}
so any cells at least touching are included}

\item{point_over}{default \code{NULL}, but can pass in SpatialPoints and will only include grid cells that have at least one point}

\item{point_n}{default 0, only used if passing in \code{point_over}. Will return only grid cells with greater than \code{point_n} points}
}
\value{
A SpatialPolygonDataFrame object with columns
\itemize{
\item \code{id}, integer id value (not the same as row.names!)
\item \code{x}, x centroid of grid cell
\item \code{y}, y centroid of grid cell
\item \code{cover}, proportion that grid cell is covered by \code{outline}
\item \code{count}, optional (only if you pass in \code{point_over})
}
}
\description{
Creates grid cells of given size over particular study area.
}
\details{
This generates a vector grid over the study area of interest. Intentionally working with vector data for use with
other feature engineering helper functions (that can pass in X/Y).
}
\examples{
library(sp) #for sp plot methods
# large grid cells
data(nyc_bor)
res <- prep_grid(nyc_bor,5000)
plot(nyc_bor)
plot(res,border='BLUE',add=TRUE)

\donttest{
# clipping so majority of grid is inside outline
res <- prep_grid(nyc_bor,2000,clip_level=0.5)
plot(nyc_bor)
plot(res,border='BLUE',add=TRUE)

# only grid cells that have at least one shooting
data(nyc_shoot)
res <- prep_grid(nyc_bor,2000,clip_level=0,nyc_shoot)
plot(nyc_bor)
plot(res,border='RED',add=TRUE)
}
}
\references{
Wheeler, A. P. (2018). The effect of 311 calls for service on crime in DC at microplaces. \emph{Crime & Delinquency}, 64(14), 1882-1903.

Wheeler, A. P., & Steenbeek, W. (2021). Mapping the risk terrain for crime using machine learning. \emph{Journal of Quantitative Criminology}, 37(2), 445-480.
}
