% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exact_dist.R
\name{powalt}
\alias{powalt}
\title{Power for Small Sample Exact Test}
\usage{
powalt(SST, p_alt, a = 0.05)
}
\arguments{
\item{SST}{a small_samptest object created with the small_samptest function}

\item{p_alt}{vector of alternative probabilities to calculate power for}

\item{a}{scaler, alpha level for power estimate, default 0.05}
}
\value{
A PowerSmallSamp object with slots for:
\itemize{
\item \code{permutations}, a dataframe that contains the exact probabilities and test statistic values for every possible permutation
\item \code{power}, the estimated power of the scenario
\item \code{alternative}, the alternative distribution of probabilities specified
\item \code{null}, the null distribution (taken from the SST object)
\item \code{alpha}, the specified alpha level
}
}
\description{
A helper function to calculate power for different alternative distributions
}
\details{
This construct a null distribution for small sample statistics for N counts in M bins. Example use cases are to see if a repeat offender have a proclivity to commit crimes on a particular day of the week (see the referenced paper). It can also be used for Benford's analysis of leading/trailing digits for small samples.
}
\examples{
# Counts for different days of the week
d <- c(3,1,2,0,0,0,0) #format N observations in M bins
res <- small_samptest(d=d,type="G")
# Power if someone only commits crime on 4 days of the week
alt_p <- c(1/4,1/4,1/4,1/4,0,0,0)
rp <- powalt(res,alt_p) #need to use previously created SST object
print(rp)

# Example for Benfords analysis
f <- 1:9
p_fd <- log10(1 + (1/f)) #first digit probabilities
#check data from Nigrini page 84
checks <- c(1927.48,27902.31,86241.90,72117.46,81321.75,97473.96,
           93249.11,89658.17,87776.89,92105.83,79949.16,87602.93,
           96879.27,91806.47,84991.67,90831.83,93766.67,88338.72,
           94639.49,83709.28,96412.21,88432.86,71552.16)
# To make example run a bit faster
checks <- checks[1:10]
# extracting the first digits
fd <- substr(format(checks,trim=TRUE),1,1)
tot <- table(factor(fd, levels=paste(f)))
resG <- small_samptest(d=tot,p=p_fd,type="Chi")
# Lets look at alt under equal probabilities (very conservative)
alt_equal <- rep(1/length(p_fd),length(p_fd))
powalt(resG,alt_equal)
}
\seealso{
\code{\link[=small_samptest]{small_samptest()}} for generating the SST object needed to estimate the power
}
