% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_combinations.formula.R
\name{find_combinations.formula}
\alias{find_combinations.formula}
\title{Generate all combinations of predictors of a formula.}
\usage{
\method{find_combinations}{formula}(object, interaction = TRUE,
  fixed = NULL, ...)
}
\arguments{
\item{object}{Formula.}

\item{interaction}{Include interaction term.}

\item{fixed}{Additional formula part to add at the beginning of
each combination.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
list containing all combinations.
}
\description{
Generate all combinations of predictors of a formula.
}
\examples{
library(psycho)

f <- as.formula("Y ~ A + B + C + D")
f <- as.formula("Y ~ A + B + C + D + (1|E)")
f <- as.formula("Y ~ A + B + C + D + (1|E) + (1|F)")

find_combinations(f)

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
