% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{correlation}
\alias{correlation}
\title{Multiple Correlations.}
\usage{
correlation(df, df2 = NULL, type = "full", method = "pearson",
  adjust = "holm")
}
\arguments{
\item{df}{The dataframe}

\item{df2}{Optional dataframe to correlate with the first one.}

\item{type}{A character string indicating which correlation type is to be
computed. One of "full" (default), "partial" or "semi" for semi-partial
correlations.}

\item{method}{A character string indicating which correlation coefficient is
to be computed. One of "pearson" (default), "kendall", or "spearman" can be
abbreviated.}

\item{adjust}{What adjustment for multiple tests should be used? ("holm",
"hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"). See
\link[stats]{p.adjust} for details about why to use "holm" rather than
"bonferroni").}
}
\value{
output
}
\description{
Compare a given score to a parent population.
}
\examples{
df <- data.frame(V1 = rnorm(1000, 0, 1),
                 V2 = rnorm(1000, 100, 15))
df$V3 <- rnorm(1000, 50, 10) * exp(df$V1)
df$V4 <- rnorm(1000, 5, 2) * log(df$V2)
df$V5 <- rnorm(1000, 5, 2) * df$V3 / df$V4


# Normal correlations
results <- psycho::correlation(df)
print(results)
results$plot()

# Partial correlations with correction
results <- psycho::correlation(df, type="partial", 
                                   method="spearman", 
                                   adjust="holm")
print(results)
results$plot()

}
\author{
Dominique Makowski, \url{https://dominiquemakowski.github.io/}
}
