% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_sample_correlation.R
\name{qc_sample_correlation}
\alias{qc_sample_correlation}
\title{Correlation based hirachical clustering of samples}
\usage{
qc_sample_correlation(
  data,
  sample,
  grouping,
  intensity_log2,
  condition,
  digestion = NULL,
  run_order = NULL,
  method = "spearman",
  interactive = FALSE
)
}
\arguments{
\item{data}{a data frame that contains at least the input variables.}

\item{sample}{a character column in the \code{data} data frame that contains the sample names.}

\item{grouping}{a character column in the \code{data} data frame that contains precursor or
peptide identifiers.}

\item{intensity_log2}{a numeric column in the \code{data} data frame that contains log2
intensity values.}

\item{condition}{a character or numeric column in the \code{data} data frame that contains the
conditions.}

\item{digestion}{optional, a character column in the \code{data} data frame that contains
information about the digestion method used. e.g. "LiP" or "tryptic control".}

\item{run_order}{optional, a character or numeric column in the \code{data} data frame that
contains the order in which samples were measured. Useful to investigate batch effects due to
run order.}

\item{method}{a character value that specifies the method to be used for correlation.
\code{"spearman"} is the default but can be changed to \code{"pearson"} or \code{"kendall"}.}

\item{interactive}{a logical value that specifies whether the plot should be interactive.
Determines if an interactive or static heatmap should be created using \code{heatmaply} or
\code{pheatmap}, respectively.}
}
\value{
A correlation heatmap that compares each sample. The dendrogram is sorted by optimal
leaf ordering.
}
\description{
A correlation heatmap is created that uses hirachical clustering to determine sample similarity.
}
\examples{
\donttest{
set.seed(123) # Makes example reproducible

# Create example data
data <- create_synthetic_data(
  n_proteins = 100,
  frac_change = 0.05,
  n_replicates = 3,
  n_conditions = 2,
  method = "effect_random"
)

# Create sample correlation heatmap
qc_sample_correlation(
  data = data,
  sample = sample,
  grouping = peptide,
  intensity_log2 = peptide_intensity_missing,
  condition = condition
)
}
}
