% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc-08-CTDTClass.R
\name{extractCTDTClass}
\alias{extractCTDTClass}
\title{CTD Descriptors - Transition (with customized amino acid
classification support)}
\usage{
extractCTDTClass(x, aagroup1, aagroup2, aagroup3)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}

\item{aagroup1}{A named list which contains the first group of customized
amino acid classification. See example below.}

\item{aagroup2}{A named list which contains the second group of customized
amino acid classification. See example below.}

\item{aagroup3}{A named list which contains the third group of customized
amino acid classification. See example below.}
}
\value{
A length \code{k * 3} named vector, \code{k} is the number of
amino acid properties used.
}
\description{
This function calculates the Transition descriptor of the
CTD descriptors, with customized amino acid classification support.
}
\note{
For this descriptor type, users need to intelligently evaluate
the underlying details of the descriptors provided, instead of using
this function with their data blindly. It would be wise to use some
negative and positive control comparisons where relevant to help guide
interpretation of the results.
}
\examples{
x <- readFASTA(system.file("protseq/P00750.fasta", package = "protr"))[[1]]

# using five customized amino acid property classification
group1 <- list(
  "hydrophobicity" = c("R", "K", "E", "D", "Q", "N"),
  "normwaalsvolume" = c("G", "A", "S", "T", "P", "D", "C"),
  "polarizability" = c("G", "A", "S", "D", "T"),
  "secondarystruct" = c("E", "A", "L", "M", "Q", "K", "R", "H"),
  "solventaccess" = c("A", "L", "F", "C", "G", "I", "V", "W")
)

group2 <- list(
  "hydrophobicity" = c("G", "A", "S", "T", "P", "H", "Y"),
  "normwaalsvolume" = c("N", "V", "E", "Q", "I", "L"),
  "polarizability" = c("C", "P", "N", "V", "E", "Q", "I", "L"),
  "secondarystruct" = c("V", "I", "Y", "C", "W", "F", "T"),
  "solventaccess" = c("R", "K", "Q", "E", "N", "D")
)

group3 <- list(
  "hydrophobicity" = c("C", "L", "V", "I", "M", "F", "W"),
  "normwaalsvolume" = c("M", "H", "K", "F", "R", "Y", "W"),
  "polarizability" = c("K", "M", "H", "F", "R", "Y", "W"),
  "secondarystruct" = c("G", "N", "P", "S", "D"),
  "solventaccess" = c("M", "S", "P", "T", "H", "Y")
)

extractCTDTClass(x, aagroup1 = group1, aagroup2 = group2, aagroup3 = group3)
}
\references{
Inna Dubchak, Ilya Muchink, Stephen R. Holbrook and Sung-Hou Kim.
Prediction of protein folding class using global description of
amino acid sequence. \emph{Proceedings of the National Academy of Sciences}.
USA, 1995, 92, 8700-8704.

Inna Dubchak, Ilya Muchink, Christopher Mayor, Igor Dralyuk and Sung-Hou Kim.
Recognition of a Protein Fold in the Context of the SCOP classification.
\emph{Proteins: Structure, Function and Genetics}, 1999, 35, 401-407.
}
\seealso{
See \code{\link{extractCTDCClass}} and
\code{\link{extractCTDDClass}} for Composition and Distribution of
the CTD descriptors with customized amino acid classification support.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
