% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-get.R
\name{getNormTheta}
\alias{getNormTheta}
\title{Get Per-Feature Theta}
\usage{
getNormTheta(object, norm.factors)
}
\arguments{
\item{object}{Any \code{propd} object.}

\item{norm.factors}{A numeric vector. The effective library size
normalization factors (e.g., from edgeR or DESeq2).}
}
\value{
A numeric vector. A theta for each feature.
}
\description{
The \code{getNormTheta} function calculates the differential proportionality
 between each feature and a set of normalization factors. When the
 normalization factors correctly remove the compositional bias, the
 resultant thetas indicate differential expression (DE). However, unlike
 other DE tests, the p-value for differential proportionality is
 not linked to the normalization factors. Here, normalization factors
 only affect the interpretation, not the statistics.
}
\details{
For use in conjunction with \code{\link{getColours}}.
}
