% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7-aldex2propr.R
\name{aldex2propr}
\alias{aldex2propr}
\title{Import \code{ALDEx2} Object}
\usage{
aldex2propr(aldex.clr, how = "rho", select)
}
\arguments{
\item{aldex.clr}{An \code{aldex.clr} object.}

\item{how}{A character string. The proportionality metric
used to build the \code{propr} object. Choose from
"rho", "phi", or "phs".}

\item{select}{Optional. Use this to subset the final
proportionality matrix without altering the result.}
}
\value{
Returns a \code{propr} object.
}
\description{
This method constructs a \code{propr} object from an
 \code{aldex.clr} object. See Details.
}
\details{
The \code{ALDEx2} package has two exceptional features useful
 in proportionality analysis too. First, \code{ALDEx2} offers
 a number of extra log-ratio transformations, toggled
 by the \code{denom} argument in \code{aldex.clr}. Second,
 \code{ALDEx2} estimates per-feature technical variation
 within each sample using Monte-Carlo instances drawn
 from the Dirichlet distribution.

The \code{aldex2propr} function takes advantage of both
 of these features by constructing a \code{propr} object
 directly from an \code{aldex.clr} object. When interpreting
 the resultant \code{propr} object, keep in mind that
 \code{ALDEx2} adds 0.5 to all \code{@counts} regardless
 of whether the counts contain any zeros. Otherwise,
 the \code{@logratio} slot contains the log-ratio
 transformed counts as averaged across all Monte Carlo
 instances. Likewise, the \code{@matrix} slot gets
 filled with the proportionality matrix as averaged
 across all Monte Carlo instances.

The \code{select} argument subsets the feature matrix
 after log-ratio transformation but before calculating
 proportionality. This reduces the run-time and RAM
 overhead without impacting the final result. Removing
 lowly abundant features prior to log-ratio transformation
 could otherwise change the proportionality measure.
}
