% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{class}
\name{propr}
\alias{[,propr,ANY,ANY-method}
\alias{[,propr-method}
\alias{adjacent}
\alias{plot,propr,missing-method}
\alias{propr}
\alias{propr-class}
\alias{show,propr-method}
\alias{simplify}
\alias{subset,propr-method}
\title{The propr Package}
\usage{
\S4method{show}{propr}(object)

\S4method{subset}{propr}(x, subset, select)

\S4method{[}{propr,ANY,ANY}(x, i = "all", j, tiny = FALSE)

\S4method{plot}{propr,missing}(x, y, prompt = TRUE, plotly = FALSE)

simplify(object)

adjacent(object)
}
\arguments{
\item{object, x}{An object of class \code{propr}.}

\item{subset}{Subsets via \code{object@counts[subset, ]}.
Use this argument to rearrange subject order.}

\item{select}{Subsets via \code{object@counts[, select]}.
Use this argument to rearrange feature order.}

\item{i}{Operation used for the subset indexing. Select from
"==", "=", ">", ">=", "<", "<=", "!=", or "all".}

\item{j}{Reference used for the subset indexing. Provide a numeric
value to which to compare the proportionality measures in the
\code{@matrix} slot.}

\item{tiny}{A logical scalar. Toggles whether to pass the indexed
result through \code{\link{simplify}}.}

\item{y}{Missing. Ignore. Leftover from the generic method
definition.}

\item{prompt}{A logical scalar. Set to \code{FALSE} to disable
the courtesy prompt when working with big data.}

\item{plotly}{A logical scalar. Set to \code{TRUE} to produce
a dynamic plot using the \code{plotly} package.}
}
\description{
Welcome to the \code{propr} package!

To learn more about how to calculate proportionality, see
 \code{\link{proportionality}}.

To learn more about proportionality plots, see
 \code{\link{visualize}}.

To learn more about differential proportionality, see
 \code{\link{prop2prob}}.

To learn more about compositional data analysis, and its relevance
 to biological count data, see the bundled vignette.
}
\section{Slots}{

\describe{
\item{\code{counts}}{A matrix. Stores the original "count matrix" input.}

\item{\code{logratio}}{A matrix. Stores the log-ratio transformed "count matrix".}

\item{\code{matrix}}{A matrix. Stores the proportionality matrix calculated by
\code{phiRcpp} or \code{rhoRcpp}.}

\item{\code{pairs}}{A vector. Indexes the proportionality metrics of interest.}
}}
\section{Methods (by generic)}{

\code{show:} Method to show \code{propr} object.


\code{subset:} Method to subset \code{propr} object.


\code{[:} Method to subset \code{propr} object.


\code{plot:} Method to plot \code{propr} object.
}

\section{Functions}{

\code{simplify:}
 This convenience function takes an indexed \code{propr} object
 and subsets the object based on that index. Then, it populates the
 \code{@pairs} slot of the new object with an updated version
 of the original index. You can call \code{simplify} from within the
 \code{[} method using the argument \code{tiny}.


\code{adjacent:}
 This function uses pairs indexed in the \code{@pairs}
 slot to build a symmetric adjacency matrix.
}

