% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{retrieve_neighbors}
\alias{retrieve_neighbors}
\title{Retrieve a list of neighbor vectors}
\usage{
retrieve_neighbors(text, projection_type, annoy_model, n,
  search_k = max(10000, 10 * n), center_pivot = TRUE, ...)
}
\arguments{
\item{text}{\link{character} containing the text related to the pivot vector}

\item{projection_type}{\link{character} defining the algorithm to use to compute the coordinates. (\code{tsne} or \code{pca})}

\item{annoy_model}{\link{RcppAnnoy} model}

\item{n}{number of neighbors to retrieve}

\item{search_k}{number of nodes to search in (\link{RcppAnnoy} parameter). Higher = ++precision & --speed}

\item{center_pivot}{put pivot text in the middle of the graph}

\item{...}{parameters passed to projection algorithm (\code{max_iter}, \code{perplexity}, \code{verbose}, \code{transformations})}
}
\description{
Use \link{RcppAnnoy} to rapidly retrieve a list of vector neighbors.
}
\details{
Transform original vectors in 2D coordinates applying either:
\itemize{
\item \href{https://en.wikipedia.org/wiki/Principal_component_analysis}{PCA}
\item \href{https://distill.pub/2016/misread-tsne/}{T-SNE}.
}
}
\examples{
if (interactive()){
# This example should be run with a higher quality model
# than the one embedded in fastrtext
library(projector)
library(fastrtext)

model_test_path <- system.file("extdata",
                               "model_unsupervised_test.bin",
                               package = "fastrtext")
model <- load_model(model_test_path)
word_embeddings <- get_word_vectors(model,
                                    words = head(get_dictionary(model), 2e5))

annoy_model <- get_annoy_model(word_embeddings, 5)

selected_word <- "out"
df <- retrieve_neighbors(text = selected_word,
                         projection_type = "tsne",
                         annoy_model = annoy_model,
                         n = 1000)
}
}
