% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_xy.R
\name{as_xy}
\alias{as_xy}
\title{Create an XY object}
\usage{
as_xy(x)
}
\arguments{
\item{x}{a data frame (column 1 = 2theta, column 2 = counts)}
}
\value{
an XY object.
}
\description{
\code{as_xy} takes a data frame of XY XRPD data and ensures that it
meets the criteria for an XY object. These requirements
include that the data contains 2 columns of numeric data in a dataframe.
Once an XY object has been created, it can easily be plotted using the
associated \code{plot.XY} method.
}
\examples{
# Load soils xrd data
data(rockjock_mixtures)

xy <- as_xy(rockjock_mixtures$Mix1)

class(xy)

\dontrun{
plot(xy, wavelength = "Cu")
plot(xy, wavelength = "Cu", interactive = TRUE)
}

}
