% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.powdRlm}
\alias{plot.powdRlm}
\title{Plotting elements of a powdRlm object}
\usage{
\method{plot}{powdRlm}(x, wavelength, mode, xlim, group, show_excluded, interactive, ...)
}
\arguments{
\item{x}{a powdRlm object}

\item{wavelength}{One of "Cu", "Co" or a custom numeric value defining the wavelength
(in Angstroms). Used to compute d-spacings.When "Cu" or "Co" are supplied, wavelengths
of 1.54056 or 1.78897 are used, respectively.}

\item{mode}{One of "fit", "residuals" or "both" defining whether to plot the fitted
patterns, the residuals of the fit, or both, respectively. Default = "fit".}

\item{xlim}{A numeric vector providing limits of the x-axis (E.g. \code{c(10, 60)}).
Defaults to full x-axis unless specified.}

\item{group}{A logical parameter used to specify whether the plotted data are grouped
according to the phase name. Default = FALSE.}

\item{show_excluded}{A logical value specifying whether the areas excluded from the
fitting are identified in the plot as grey rectangles. Default \code{= TRUE}.}

\item{interactive}{logical. If TRUE then the output will be an interactive
ggplotly object. If FALSE then the output will be a ggplot object.}

\item{...}{other arguments}
}
\description{
\code{plot.powdRlm} is designed to provide easy, adaptable plots
of full pattern summation outputs produced from \code{\link{fps_lm}}.
}
\details{
When seeking to inspect the results from full pattern summation, interactive
plots are particularly useful and can be specified with the \code{interactive}
argument.
}
\examples{
data(rockjock)
data(rockjock_mixtures)

#Compute the PCA and loadings
x1 <- xrpd_pca(rockjock_mixtures,
               mean_center = TRUE,
               bin_size = 1,
               root_transform = 1)

\dontrun{
fps_lm_out <- fps_lm(rockjock,
                     smpl = data.frame("x" = x1$loadings$tth,
                                       "y" = x1$loadings$Dim.1),
                     refs = rockjock$phases$phase_id,
                     std = "QUARTZ",
                     align = 0.3,
                     p = 0.01)

plot(fps_lm_out,
     wavelength = "Cu",
     interactive = TRUE,
     group = TRUE)

}
}
