% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnet_dispatch.R
\name{glmnet_helper}
\alias{glmnet_helper}
\title{Helper function(glmnet).}
\usage{
glmnet_helper(X, Y, W, Z.trans = TRUE, cv.steps = 100,
  parallelize = FALSE, cores.to.use = NULL, lambda.set.Y = NULL,
  lambda.set.W = NULL)
}
\arguments{
\item{X}{A matrix of covariates (must be all numeric)}

\item{Y}{A vector of the target variable, of same length as the number of rows of Y, must be numeric}

\item{W}{A vector of the treatment variable, of same length as the number of rows of X, must be numeric}

\item{Z.trans}{A logical value indicating whether to standardize inputs, defaults to TRUE}

\item{cv.steps}{The number of folds for k-fold cross-validation of the hyperparameter tuning, defaults to 100}

\item{parallelize}{Whether to run the simulations in parallel, using every available core. Defaults to FALSE.}

\item{cores.to.use}{The number of cores to use. If NULL (the default), uses the maximum number of cores detected by detectCores.}

\item{lambda.set.Y}{Allows the user to specify lambda for the Y model, defaults to null.}

\item{lambda.set.W}{Allows the user to specify lambda for the W model, defaults to null.}
}
\value{
A list with two elements: The fitted W model and the fitted Y model.
}
\description{
Helper function that dispatches to glmnet for the post-double estimation.
}
\details{
This function does not support the full range of arguments to glmnet, intentionally. If you need something specific please refer to custom_generator.
}
\examples{


  n = 2000; p = 10
  X = matrix(rnorm(n*p), n, p)
  W = rbinom(n, 1, 0.4 + 0.2 * (X[,1] > 0))
  Y = pmax(X[,1], 0) * W + X[,2] + pmin(X[,3], 0) + rnorm(n)

glmnet_helper(X = X, Y = Y, W = W, lambda.set.W = 0.7, lambda.set.Y = 0.5)




}
