% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_version.R
\name{fsa_metadata}
\alias{fsa_metadata}
\title{Retrieve Metadata}
\usage{
fsa_metadata(x)
}
\arguments{
\item{x}{The path to the folder from the current directory where the .fsa
files that will be analyzed are stored.}
}
\value{
A data frame that contains the metadata of the machine and run
extracted from the .fsa file.
One row for each .fsa file in directory x and the following columns:
retrieved_sample_name, batch_container_name,  fsa_version, user,
run_start_date, run_start_time, machine_type,machineN_serial.
}
\description{
Retrieves basic info from .fsa files about the sample and run,and aggregates
multiple samples in a single object.
}
\examples{
file_path <- system.file("extdata", package = "pooledpeaks")
fsa_metadata(x = file_path)

}
