% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wmcloud_translate.R
\name{wmcloud_translate}
\alias{wmcloud_translate}
\title{Translate content using WMCloud}
\usage{
wmcloud_translate(
  content,
  target_language = "en",
  source_language = "en",
  format = "text",
  model = "nllb200-600M"
)
}
\arguments{
\item{content}{The content to translate. Can be plain text, a URL (for a webpage), a JSON string, or a Markdown string.}

\item{target_language}{The target language for the translation (default is "en").}

\item{source_language}{The source language of the content (default is "en").}

\item{format}{The format of the content ("json", "markdown", "text", "webpage").}

\item{model}{The model to use for the translation (only "nllb200-600M" is currently known to work).}
}
\value{
The translated content.
}
\description{
This function sends a POST request to the WMCloud translation API with the specified parameters,
parses the JSON response, and returns the translated content.
}
\examples{
\dontrun{
# Translate plain text
wmcloud_translate("rijst",
target_language = "es",
source_language = "nl", format = "text")

# Translate a webpage
wmcloud_translate("https://en.m.wikivoyage.org/wiki/Goes",
target_language = "es",
source_language = "en", format = "webpage")

# Translate JSON content
wmcloud_translate('{
    "id": 1,
    "title": "Chicken Biryani",
    "description": "Chicken Biryani is a savory chicken and rice dish",
    "ingredients": [ "Vegetable oil", "Garlic", "Ginger" ,"Rice"]
}
               ', target_language = "es", source_language = "en", format = "json")

# Translate Markdown content
wmcloud_translate('# Heading

This is a [link to Wikipedia](https://wikipedia.org)
                ', target_language = "es", source_language = "en", format = "markdown")
}
}
