% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-select.R
\name{gradstep}
\alias{gradstep}
\title{Automatic step selection for numerical derivatives}
\usage{
gradstep(
  FUN,
  x,
  h0 = NULL,
  zero.tol = sqrt(.Machine$double.eps),
  method = c("plugin", "SW", "CR", "CRm", "DV", "M"),
  diagnostics = FALSE,
  control = NULL,
  cores = 1,
  preschedule = getOption("pnd.preschedule", TRUE),
  cl = NULL,
  ...
)
}
\arguments{
\item{FUN}{Function for which the optimal numerical derivative step size is needed.}

\item{x}{Numeric vector or scalar: the point at which the derivative is computed
and the optimal step size is estimated.}

\item{h0}{Numeric vector or scalar: initial step size, defaulting to a relative step of
slightly greater than .Machine$double.eps^(1/3) (or absolute step if \code{x == 0}).}

\item{zero.tol}{Small positive integer: if \code{abs(x) >= zero.tol}, then, the automatically
guessed step size is relative (\code{x} multiplied by the step), unless an auto-selection
procedure is requested; otherwise, it is absolute.}

\item{method}{Character indicating the method: \code{"CR"} for \insertCite{curtis1974choice}{pnd},
\code{"CR"} for modified Curtis--Reid, "DV" for \insertCite{dumontet1977determination}{pnd},
\code{"SW"} \insertCite{stepleman1979adaptive}{pnd}, and "M" for
\insertCite{mathur2012analytical}{pnd}.}

\item{diagnostics}{Logical: if \code{TRUE}, returns the full iteration history
including all function evaluations. Passed to the appropriate \code{step.XX} function.}

\item{control}{A named list of tuning parameters for the method. If \code{NULL},
default values are used. See the documentation for the respective methods. Note that
if \code{control$diagnostics} is \code{TRUE}, full iteration history
including all function evaluations is returned; different methods have
slightly different diagnostic outputs.}

\item{cores}{Integer specifying the number of CPU cores used for parallel computation.
Recommended to be set to the number of physical cores on the machine minus one.}

\item{preschedule}{Logical: if \code{TRUE}, disables pre-scheduling for \code{mclapply()}
or enables load balancing with \code{parLapplyLB()}. Recommended for functions that
take less than 0.1 s per evaluation.}

\item{cl}{An optional user-supplied \code{cluster} object  (created by \code{makeCluster}
or similar functions). If not \code{NULL}, the code uses \code{parLapply()} (if \code{preschedule}
is \code{TRUE}) or \code{parLapplyLB()} on that cluster on Windows, and \code{mclapply}
(fork cluster) on everything else.}

\item{...}{Passed to FUN.}
}
\value{
A list similar to the one returned by \code{optim()} and made of
concatenated individual elements coordinate-wise lists: \code{par} -- the optimal
step sizes found, \code{value} -- the estimated numerical gradient,
\code{counts} -- the number of iterations for each coordinate,
\code{abs.error} -- an estimate of the total approximation error
(sum of truncation and rounding errors),
\code{exitcode} -- an integer code indicating the termination status:
\code{0} indicates optimal termination within tolerance,
\code{1} means that the truncation error (CR method) or the third derivative
(DV method) is zero and large step size is preferred,
\code{2} is returned if there is no change in step size within tolerance,
\code{3} indicates a solution at the boundary of the allowed value range,
\code{4} signals that the maximum number of iterations was reached.
\code{message} -- summary messages of the exit status.
If \code{method.ards$diagnostics} is \code{TRUE}, \code{iterations} is a list of lists
including the full step size search path, argument grids, function values on
those grids, estimated error ratios, and estimated derivative values for
each coordinate.
}
\description{
Automatic step selection for numerical derivatives
}
\details{
We recommend using the Mathur algorithm because it does not suffer
from over-estimation of the truncation error in the Curtis--Reid approach
and from sensitivity to near-zero third derivatives in the Dumontet--Vignes
approach. It really tries muliple step sizes simultaneously and handles missing
values due to bad evaluations for inadequate step sizes really in a robust manner.
}
\examples{
gradstep(x = 1, FUN = sin, method = "CR")
gradstep(x = 1, FUN = sin, method = "CRm")
gradstep(x = 1, FUN = sin, method = "DV")
gradstep(x = 1, FUN = sin, method = "SW")
gradstep(x = 1, FUN = sin, method = "M")
# Works for gradients
gradstep(x = 1:4, FUN = function(x) sum(sin(x)))
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=step.CR]{step.CR()}} for Curtis--Reid (1974) and its modification,
\code{\link[=step.DV]{step.DV()}} for Dumontet--Vignes (1977),
\code{\link[=step.SW]{step.SW()}} for Stepleman--Winarsky (1979), and
\code{\link[=step.M]{step.M()}} for Mathur (2012).
}
