% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{gcv_convert}
\alias{gcv_convert}
\title{Convert geometric variance or standard deviation to a geometric coefficient of variation}
\usage{
gcv_convert(gvar = gsd^2, gsd)
}
\arguments{
\item{gvar}{The geometric variance (note that this is the variance not a
vector of values to compute the gcv from)}

\item{gsd}{The geometric standard deviation}
}
\value{
Geometric coefficient of variation
}
\description{
The equation used is: \code{100*sqrt(exp(gvar)-1)}
}
\examples{
gcv_convert(0.2)
gcv_convert(gsd=0.2)
}
\references{
\url{http://onbiostatistics.blogspot.com/2008/07/geometric-statistics-geometric-cv-vs.html}
}
\author{
Bill Denney
}
