% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_proposal_sample_changea_cor.R
\name{generate_proposal_sample_changea_cor}
\alias{generate_proposal_sample_changea_cor}
\title{Generate samples based on sampling covariance matrix and rg matrix for target disease}
\usage{
generate_proposal_sample_changea_cor(
  Results_full_rg,
  Results_full_rg_array,
  plei_h2_idx,
  ratio_a
)
}
\arguments{
\item{Results_full_rg}{genetic correlation matrix.}

\item{Results_full_rg_array}{genetic correlation jackknife-block array.}

\item{plei_h2_idx}{index of the target disease in the rg_mat.}

\item{ratio_a}{corrected ratio.}
}
\value{
noisy_inversed_element for bias correction
}
\description{
This function is used to generate samples based on sampling covariance matrix and rg matrix for target disease
}
\examples{
data(Results_full_rg_15D)
data(Results_full_rg_array_15D)
plei_h2_idx<-1
ratio_a <- 0.75
generate_proposal_sample_changea_cor(Results_full_rg_15D,
 Results_full_rg_array_15D, plei_h2_idx, ratio_a)
}
