% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/month_to_weekx.R
\name{month_to_weekx}
\alias{month_to_weekx}
\title{Convert a Demand expressed in Monthly buckets into Weekly buckets}
\usage{
month_to_weekx(dataset, DFU, W1, W2, W3, W4, Period, Demand)
}
\arguments{
\item{dataset}{a dataframe with the demand in monthly bucket for each item}

\item{DFU}{name of an item, a SKU, or a node like an item x location}

\item{W1}{percentage of demand done during the first week}

\item{W2}{percentage of demand done during the second week}

\item{W3}{percentage of demand done during the third week}

\item{W4}{percentage of demand done during the fourth week}

\item{Period}{a monthly period of time that we want to convert into weekly buckets}

\item{Demand}{the quantity of an item planned to be consumed in units for a given period}
}
\value{
a dataframe with the Demand expressed in weekly buckets for each item
}
\description{
Convert a Demand expressed in Monthly buckets into Weekly buckets
}
\examples{
month_to_week(dataset = demo_monthly_dmd, DFU, Period, Demand)

}
