% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaze.R
\name{gaze}
\alias{gaze}
\title{Mimic Stargazer Output to Display Multiple Models}
\usage{
gaze(..., include_glance = TRUE, glance_vars = c("adj.r.squared",
  "sigma", "AIC"), digits = 3)
}
\arguments{
\item{...}{models to be tidied.  Arguments may be named or unnamed.
For named arguments, the model will be identfied by the argument 
name; for unnamed arguments, the object name will be the identifier.}

\item{include_glance}{\code{logical(1)} Determines if \code{glance} (fit)
statistics are displayed under the models.}

\item{glance_vars}{\code{character}. A vector of statistics returned by
\code{glance} that are to be displayed for each model. Defaults are 
subject to change in future versions.}

\item{digits}{\code{numeric(1)} The number of digits used for rounding.}
}
\description{
Tidy multiple models and display coefficients and 
  test statistics in a side-by-side format.
}
\details{
This function is still in development.  Significant stars 
  will be added in a future version. Note that function defaults may 
  be subject to change.
}
\section{Functional Requirements}{

\enumerate{
  \item Return a data frame object
  \item Cast an error if \code{include_glance} is not \code{logical(1)}
  \item Cast an error if \code{glance_vars} is not a \code{character} 
    vector.
  \item Cast an error if \code{digits} is not \code{"integerish(1)"}.
}
}

\examples{
fit1 <- lm(mpg ~ qsec + am + wt + gear + factor(vs), data = mtcars)
fit2 <- lm(mpg ~ am + wt + gear + factor(vs), data = mtcars)

gaze(fit1, fit2)
gaze(with_qsec = fit1, 
     without_qsec = fit2)
gaze(fit1, fit2, include_glance = FALSE)
gaze(fit1, fit2, glance_vars = c("AIC", "BIC"))

}
