% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_databricks.R
\name{board_databricks}
\alias{board_databricks}
\title{Use a Databricks Volume as a board}
\usage{
board_databricks(
  folder_url,
  host = NULL,
  prefix = NULL,
  versioned = TRUE,
  cache = NULL
)
}
\arguments{
\item{folder_url}{The path to the target folder inside Unity Catalog. The path
must include the catalog, schema, and volume names, preceded by 'Volumes/',
like \code{"/Volumes/my-catalog/my-schema/my-volume"}.}

\item{host}{Your \href{https://docs.databricks.com/en/workspace/workspace-details.html#workspace-url}{Workspace Instance URL}.
Defaults to \code{NULL}. If \code{NULL}, it will search for this URL in two different
environment variables, in this order:
\itemize{
\item 'DATABRICKS_HOST'
\item 'CONNECT_DATABRICKS_HOST'
}}

\item{prefix}{Prefix within the folder that this board will occupy.
You can use this to maintain multiple independent pin boards within a single
Databricks Volume. Make sure to end with '/', to take advantage of
Databricks Volume directory-like handling.}

\item{versioned}{Should this board be registered with support for versions?}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}
}
\description{
Pin data to a \href{https://docs.databricks.com/en/sql/language-manual/sql-ref-volumes.html}{Databricks Volume}
}
\section{Authentication}{
\code{board_databricks()} searches for an authentication token in three different
places, in this order:
\itemize{
\item 'DATABRICKS_TOKEN' environment variable
\item 'CONNECT_DATABRICKS_TOKEN' environment variable
\item OAuth Databricks token inside the RStudio API
}

In most cases, the authentication will be a Personal Authentication
Token ('PAT') that is saved as the 'DATABRICKS_TOKEN' environment variable.
To obtain a 'PAT' see: \href{https://docs.databricks.com/en/dev-tools/auth/pat.html}{Databricks personal access token authentication}.
}

\section{Details}{
\itemize{
\item The functions in pins do not create a new Databricks Volume.
\item \code{board_databricks()} is powered by the httr2 package, which is a
suggested dependency of pins (not required for pins in general). If
you run into errors when deploying content to a server like
\url{https://www.shinyapps.io} or \href{https://posit.co/products/enterprise/connect/}{Connect},
add \code{requireNamespace("httr2")} to your app or document for \href{https://docs.posit.co/connect/user/troubleshooting/#render-missing-r-package}{automatic dependency discovery}.
}
}

\examples{
\dontrun{
board <- board_databricks("/Volumes/my-catalog/my-schema/my-volume")
board \%>\% pin_write(mtcars)
board \%>\% pin_read("mtcars")

# A prefix allows you to have multiple independent boards in the same folder.
project_1 <- board_databricks(
  folder_url = "/Volumes/my-catalog/my-schema/my-volume",
  prefix = "project1/"
)
project_2 <- board_databricks(
  folder_url = "/Volumes/my-catalog/my-schema/my-volume",
  prefix = "project2/"
)
}
}
