% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_piece_obj.R
\name{save_ellipsoid_obj}
\alias{save_ellipsoid_obj}
\alias{save_peg_doll_obj}
\title{Alternative Wavefront OBJ file generators}
\usage{
save_ellipsoid_obj(
  piece_side = "bit_face",
  suit = 1,
  rank = 1,
  cfg = getOption("piecepackr.cfg", pp_cfg()),
  ...,
  x = 0,
  y = 0,
  z = 0,
  angle = 0,
  axis_x = 0,
  axis_y = 0,
  width = NA,
  height = NA,
  depth = NA,
  filename = tempfile(fileext = ".obj"),
  subdivide = 3
)

save_peg_doll_obj(
  piece_side = "pawn_top",
  suit = 1,
  rank = 1,
  cfg = getOption("piecepackr.cfg", pp_cfg()),
  ...,
  x = 0,
  y = 0,
  z = 0,
  angle = 0,
  axis_x = 0,
  axis_y = 0,
  width = NA,
  height = NA,
  depth = NA,
  filename = tempfile(fileext = ".obj"),
  res = 72
)
}
\arguments{
\item{piece_side}{A string with piece and side separated by a underscore e.g. "coin_face"}

\item{suit}{Number of suit (starting from 1).}

\item{rank}{Number of rank (starting from 1)}

\item{cfg}{Piecepack configuration list or \code{pp_cfg} object,
a list of \code{pp_cfg} objects,
or a character vector referring to names in \code{envir}
or a character vector referring to object names that
can be retrieved by \code{base::dynGet()}.}

\item{...}{Ignored.}

\item{x}{Where to place piece on x axis of viewport}

\item{y}{Where to place piece on y axis of viewport}

\item{z}{z-coordinate of the piece.  Has no effect if \code{op_scale} is \code{0}.}

\item{angle}{Angle (on xy plane) to draw piece at}

\item{axis_x}{First coordinate of the axis unit vector.}

\item{axis_y}{Second coordinate of the axis unit vector.}

\item{width}{Width of piece}

\item{height}{Height of piece}

\item{depth}{Depth (thickness) of piece.  Has no effect if \code{op_scale} is \code{0}.}

\item{filename}{Name of Wavefront OBJ object.}

\item{subdivide}{Increasing this value makes for a smoother ellipsoid (and larger OBJ file and slower render).
See \code{\link[rgl]{ellipse3d}}.}

\item{res}{Resolution of the faces.}
}
\description{
These are alternative Wavefront OBJ generators intended to be used as a \code{obj_fn} attribute
in a \code{pp_cfg()} \dQuote{configuration list}.
\code{save_ellipsoid_obj} saves an ellipsoid with a color equal to that piece's \code{background_color}.
\code{save_peg_doll_obj} saves a \dQuote{peg doll} style doll with a color equal to that piece's \code{edge_color}
with a \dQuote{pawn belt} around it's waste from that suit's and rank's \code{belt_face}.
}
\seealso{
See \code{\link[=pp_cfg]{pp_cfg()}} for a discussion of \dQuote{configuration lists}.
Wavefront OBJ file generators are used by \code{\link[=save_piece_obj]{save_piece_obj()}} and (by default)
\code{\link[=piece3d]{piece3d()}} (\code{rgl} wrapper), \code{\link[=piece]{piece()}} (\code{rayrender} wrapper),
and \code{\link[=piece_mesh]{piece_mesh()}} (\code{rayvertex} wrapper).
}
