% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrib.R
\name{contrib}
\alias{contrib}
\alias{contrib.piar_index}
\alias{contrib2DF}
\alias{contrib2DF.piar_index}
\alias{contrib<-}
\alias{contrib<-.piar_index}
\alias{set_contrib}
\alias{set_contrib_from_index}
\title{Extract percent-change contributions}
\usage{
contrib(x, ...)

\method{contrib}{piar_index}(x, level = levels(x)[1L], period = time(x), ..., pad = 0)

contrib2DF(x, ...)

\method{contrib2DF}{piar_index}(x, level = levels(x)[1L], period = time(x), ...)

contrib(x, ...) <- value

\method{contrib}{piar_index}(x, level = levels(x)[1L], period = time(x), ...) <- value

set_contrib(x, ..., value)

set_contrib_from_index(x)
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elemental_index]{elemental_index()}}.}

\item{...}{Further arguments passed to or used by methods.}

\item{level}{The level of an index for which percent-change contributions
are desired, defaulting to the first level (usually the top-level for an
aggregate index). \code{contrib2DF()} can accept multiple levels.}

\item{period}{The time periods for which percent-change contributions are
desired, defaulting to all time periods.}

\item{pad}{A numeric value to pad contributions so that they fit into a
rectangular array when products differ over time. The default is 0.}

\item{value}{A numeric matrix of replacement contributions with a row for
each product and a column for each time period. Recycling occurs along time
periods.}
}
\value{
\code{contrib()} returns a matrix of percent-change contributions with a column
for each \code{period} and a row for each product (sorted) for which there are
contributions in \code{level}. Contributions are padded with \code{pad} to fit into a
rectangular array when products differ over time. The replacement methods
returns a copy of \code{x} with contributions given by the matrix \code{value}.
(\code{set_contrib()} is an alias that's easier to use with pipes.)
\code{set_contrib_from_index()} is a helper to return a copy of \code{x} with all
contributions set to the corresponding index value minus 1.

\code{contrib2DF()} returns a data frame of contributions with four
columns: \code{period}, \code{level}, \code{product}, and \code{value}.
}
\description{
Extract a matrix or data frame of percent-change contributions from a price
index.
}
\examples{
prices <- data.frame(
  rel = 1:8,
  period = rep(1:2, each = 4),
  ea = rep(letters[1:2], 4)
)

index <- elemental_index(prices, rel ~ period + ea, contrib = TRUE)

pias <- aggregation_structure(
  list(c("top", "top", "top"), c("a", "b", "c")), weights = 1:3
)

index <- aggregate(index, pias, na.rm = TRUE)

# Percent-change contributions for the top-level index

contrib(index)

contrib2DF(index)

# Calculate EA contributions for the chained index

library(gpindex)

arithmetic_contributions(
  as.matrix(chain(index))[c("a", "b", "c"), 2],
  weights(pias)
)

}
\seealso{
Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}},
\code{\link{as.data.frame.piar_index}()},
\code{\link{as.ts.piar_index}()},
\code{\link{chain}()},
\code{\link{head.piar_index}()},
\code{\link{is.na.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}},
\code{\link{merge.piar_index}()},
\code{\link{split.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{window.piar_index}()}
}
\concept{index methods}
