% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phybreak-class.R
\name{phybreak}
\alias{phybreak}
\title{Create a phybreak-object from data and prior distributions.}
\usage{
phybreak(data, times = NULL, mu = 1e-04, gen.shape = 3, gen.mean = 1,
  sample.shape = 3, sample.mean = 1, wh.model = 3, wh.slope = 1,
  est.gen.mean = TRUE, prior.mean.gen.mean = 1, prior.mean.gen.sd = Inf,
  est.sample.mean = TRUE, prior.mean.sample.mean = 1,
  prior.mean.sample.sd = Inf, est.wh.slope = TRUE, prior.wh.shape = 1,
  prior.wh.mean = 1, use.tree = FALSE)
}
\arguments{
\item{data}{The sequence data. These can be given as objects of class \code{'DNAbin'} or \code{'phyDat'}, or in a \code{matrix}
with nucleotides, each row a host, each column a nucleotide. All nucleotides that are not \code{'a'}, \code{'c'}, \code{'g'}, 
or \code{'t'}, will be turned into \code{'n'}. If the sequences are named, these names will be used. It is also possible
to provide the data in object of class \code{'obkData'}, containing sequences and sampling times as metadata with 
these sequences.}

\item{times}{Vector of sampling times (not needed if the data are of class \code{'obkData'}). If the vector is named,
these names will be used to identify the hosts.}

\item{mu}{Initial value for mutation rate (defined per site per unit of time). 
NOTE: mutation is defined as assignment of a random nucleotide at a particular site; this could be the 
nucleotide that was there before the mutation event. Therefore, the actual rate of change of nucleotides 
is \code{0.75*mu}.}

\item{gen.shape}{Shape parameter of the generation interval distribution (not estimated).}

\item{gen.mean}{Initial value for the mean generation interval, i.e. the interval between infection of a secondary
case by a primary case.}

\item{sample.shape}{Shape parameter of the sampling interval distribution (not estimated), i.e. the interval between
infection and sampling of a host.}

\item{sample.mean}{Initial value for the mean sampling interval.}

\item{wh.model}{The model for within-host pathogen dynamics (effective pathogen population size = 
N*gE = actual population size * pathogen generation time), used to simulate coalescence events. Options are:
\enumerate{
  \item Effective size = 0, so coalescence occurs 'just before' transmission in the infector
  \item Effective size = Inf, so coalescence occurs 'just after' transmission in the infectee
  \item Effective size at time t after infection = \code{wh.slope * t}
}}

\item{wh.slope}{Initial value for the within-host slope, used if \code{wh.model = 3}.}

\item{est.gen.mean}{Whether to estimate the mean generation interval or keep it fixed.}

\item{prior.mean.gen.mean}{Mean of the (gamma) prior distribution of mean generation interval \code{mG} 
(only if \code{est.gen.mean = TRUE}).}

\item{prior.mean.gen.sd}{Standard deviation of the (gamma) prior distribution of mean generation interval \code{mG} 
(only if \code{est.gen.mean = TRUE}).}

\item{est.sample.mean}{Whether to estimate the mean sampling interval or keep it fixed.}

\item{prior.mean.sample.mean}{Mean of the (gamma) prior distribution of mean sampling interval \code{mS} 
(only if \code{est.sample.mean = TRUE}).}

\item{prior.mean.sample.sd}{Standard deviation of the (gamma) prior distribution of mean sampling interval \code{mS} 
(only if \code{est.sample.mean = TRUE}).}

\item{est.wh.slope}{Whether to estimate the within-host slope or keep it fixed.}

\item{prior.wh.shape}{Shape parameter of the (gamma) prior distribution of \code{slope} 
(only if \code{est.wh.slope = TRUE}).}

\item{prior.wh.mean}{Mean of the (gamma) prior distribution of \code{slope} 
(only if \code{est.wh.slope = TRUE}).}

\item{use.tree}{Whether to use the transmission and phylogenetic tree given in data of class \code{'obkData'}, 
to create a \code{phybreak}-object with an exact copy of the outbreak. This requires more data in \code{data}: 
the slot \code{individuals} with vectors \code{infector} and \code{date}, and the slot \code{trees} with at least 
one phylogenetic tree. Such data can be simulated with \code{\link{sim.phybreak}}.}
}
\value{
An object of class \code{phybreak} with the following elements
  \describe{
    \item{d}{a \code{list} with data, i.e. names, sequences, sampling times, and total number of SNPs.}
    \item{v}{a \code{list} with current state of all nodes in the tree: times, hosts in which they reside,
      parent nodes, node types (sampling, coalescent, or transmission)}
    \item{p}{a \code{list} with the parameter values}
    \item{h}{a \code{list} with helper information for the MCMC-method: \code{si.mu} and \code{si.wh} for 
      efficiently proposing \code{mu} and \code{slope}, matrix \code{dist} with weights for infector sampling 
      based on sequence distances, \code{logical}s \code{est.mG}, \code{est.mS}, and \code{est.wh.slope} whether to estimate 
      mean generation interval \code{mG}, mean sampling interval \code{mS}, and within-host \code{slope}, 
      and parameters for the priors of \code{mG}, \code{mS}, and \code{slope}.
    }
    \item{s}{an empty \code{list} that will contain vector and matrices with the posterior samples; 
      in matrices, the rows are nodes in the phylogenetic tree, the columns are the samples}
  }
}
\description{
phybreak takes as data either an \code{'obkData'}-object or a \code{matrix} with sequences 
(individuals in rows, nucleotides in columns). If only sequences are used, a vector with 
sampling times is also needed. Parameter values are used as initial values in the MCMC-chain 
or kept fixed. All variables are initialized by random samples from the prior distribution, 
unless the tree in the obkData is used (\code{use.tree = TRUE}).
}
\examples{
simulation <- sim.phybreak()
MCMCstate <- phybreak(data = simulation$sequences, times = simulation$sample.times)

\dontrun{
 ### only if 'OutbreakTools' is installed
 simulation <- sim.phybreak(output-class = "obkData")
 MCMCstate <- phybreak(data = simulation, use.tree = TRUE)
}

sampletimedata <- c(0,2,2,4,4)
sampleSNPdata <- matrix(c("a","a","a","a","a",
                          "a","c","c","c","c",
                          "t","t","t","g","g"), nrow = 5)
MCMCstate <- phybreak(data = sampleSNPdata, times = sampletimedata)
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
\references{
\href{http://dx.doi.org/10.1101/069195}{Klinkenberg et al, on biorXiv}.
}

