% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.tag.r
\name{wb2rect_spct}
\alias{wb2rect_spct}
\alias{fast_wb2rect_spct}
\title{Create tagged spectrum from wavebands}
\usage{
wb2rect_spct(w.band, short.names = TRUE, chroma.type = "CMF")

fast_wb2rect_spct(w.band, chroma.type = "CMF", simplify = TRUE)
}
\arguments{
\item{w.band}{waveband or list of waveband objects The waveband(s) determine
the wavelengths in variable \code{w.length} of the returned spectrum}

\item{short.names}{logical Flag indicating whether to use short or long names
for wavebands}

\item{chroma.type}{character telling whether "CMF", "CC", or "both" should be
returned for human vision, or an object of class \code{chroma_spct} for any
other trichromic visual system.}

\item{simplify}{logical Flag indicating whether to merge neighboring
rectangles of equal color. Simplification is done only for narrow
wavebands.}
}
\value{
A \code{generic.spectrum} object, with columns w.length, wl.low,
  wl.hi, wl.color, wb.color and wb.name. The w.length values are the
  midpoint of the wavebands, wl.low and wl.high give the boundaries of the
  wavebands, wl.color the color definition corresponding to the wavelength at
  the center of the waveband and wb.color the color of the waveband as a
  whole (assuming a flat energy irradiance spectrum). Different spectral data
  variables are set to zero and added making the returned value compatible
  with classes derived from \code{generic_spct}.
}
\description{
Create a generic_spct object with wavelengths from the range of wavebands in
a list. The spectrum is suitable for plotting labels, symbols, rectangles or
similar, as the midpoint of each waveband is added to the spectrum.
}
\note{
Function \code{fast_wb2rect_spct()} differs from \code{wb2rect_spct()}
  in that it computes colors for narrow wavebands based on the midpoint
  wavelength and uses vectorization when possible. It always returns color
  definitions with short names, which are also used as waveband names for
  narrow wavebands and merged wavebands. The purpose of merging of rectangles
  is to speed up rendering and to reduce the size of vector graphics output.
  This function should be used with care as the color definitions returned
  are only approximate and original waveband names can be lost.
}
\seealso{
Other tagging and related functions: 
\code{\link{is_tagged}()},
\code{\link{tag}()},
\code{\link{untag}()},
\code{\link{wb2spct}()},
\code{\link{wb2tagged_spct}()}
}
\concept{tagging and related functions}
