% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.quantum.r
\name{as_quantum}
\alias{as_quantum}
\title{Convert spectral energy irradiance into spectral photon irradiance}
\usage{
as_quantum(w.length, s.e.irrad)
}
\arguments{
\item{w.length}{numeric vector of wavelengths (nm).}

\item{s.e.irrad}{numeric vector of spectral (energy) irradiance values.}
}
\value{
A numeric vector of spectral photon irradiances.
}
\description{
Convert spectral energy irradiance [W m-2 nm-1] into spectral photon
irradiance expressed as number of photons [s-1 m-2 nm-1]
}
\examples{
with(sun.data, as_quantum(w.length, s.e.irrad))

}
\seealso{
Other quantity conversion functions: 
\code{\link{A2T}()},
\code{\link{Afr2T}()},
\code{\link{T2A}()},
\code{\link{T2Afr}()},
\code{\link{any2T}()},
\code{\link{e2q}()},
\code{\link{e2qmol_multipliers}()},
\code{\link{e2quantum_multipliers}()},
\code{\link{q2e}()}
}
\concept{quantity conversion functions}
