% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.waveband.r
\name{trim_waveband}
\alias{trim_waveband}
\title{Trim (or expand) head and/or tail}
\usage{
trim_waveband(
  w.band,
  range = NULL,
  low.limit = 0,
  high.limit = Inf,
  trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = TRUE,
  trunc.labels = getOption("photobiology.brief.trunc.names", default = c("]", "["))
)
}
\arguments{
\item{w.band}{an object of class "waveband" or a list of such objects.}

\item{range}{a numeric vector of length two, or any other object for which
function range() will return a numeric vector of two wavelengths (nm).}

\item{low.limit}{shortest wavelength to be kept (defaults to 0 nm).}

\item{high.limit}{longest wavelength to be kept (defaults to Inf nm).}

\item{trim}{logical (default is TRUE which trims the wavebands at the
boundary, while FALSE discards wavebands that are partly off-boundary).}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}

\item{trunc.labels}{character vector of length one or two. The first string
will be prepended to the waveband name and label on left truncation and the
second appended on right truncation. If the vector is of length one, the
same string will be used in both cases.}
}
\value{
The returned value is a waveband object or a list of waveband objects
  depending on whether a single waveband object or a list of waveband objects
  was supplied as argument to formal parameter \code{w.band}. If no waveband
  is retained, in the first case,  a NULL waveband object is returned, and in
  the second case, a list of length zero is returned. If the input is a
  named, list, names are preserved in the returned list.
}
\description{
Trimming of waveband boundaries can be needed when the spectral data do not
cover the whole waveband, or wavebands may have to be removed altogether.
}
\details{
This function will accept both individual wavebands or list of
  wavebands. When the input is a list, wavebands outside the range of the
  range will be removed from the list, and those partly outside the
  target range either "trimmed" to this edge truncated if \code{trim =
  TRUE} is passed or excluded if \code{trim = FALSE}). Waveband objects
  contain a name and a label that are used to label the returned values of
  calculations that make use of them. When a waveband object is truncated so
  that the definition changes, the name and label are also modified so that
  the change is visible when they are used. The name and label have a string
  prepended or appended, and what strings are used can be set with an R
  option.
}
\note{
Modification of the name and label stored in the wavebands passed as
  input is done so that summaries produced with the modified objects can be
  recognized as different from those computed using the original definitions
  when the waveband objects are used. When the input is a named list, the
  names of the retained members of the list are not modified as these are not
  part of the definitions.
}
\examples{
VIS <- waveband(c(380, 760)) # manometers

trim_waveband(VIS, c(400,700))
trim_waveband(VIS, low.limit = 400)
trim_waveband(VIS, high.limit = 700)
trim_waveband(VIS, c(400,700), trunc.labels = c(">", "<"))
trim_waveband(VIS, c(400,700), trunc.labels = "!")

}
\seealso{
Other trim functions: 
\code{\link{clip_wl}()},
\code{\link{trim_spct}()},
\code{\link{trim_wl}()}
}
\concept{trim functions}
