% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.phenology.R
\name{summary.phenology}
\alias{summary.phenology}
\title{Print the result information from a result object.}
\usage{
\method{summary}{phenology}(
  object,
  resultmcmc = NULL,
  season = NULL,
  chain = 1,
  series = "all",
  replicate.CI.mcmc = "all",
  replicate.CI = 10000,
  level = 0.95,
  print = TRUE,
  ...
)
}
\arguments{
\item{object}{A result file generated by fit_phenology}

\item{resultmcmc}{A mcmc object}

\item{season}{The number of season to analyze}

\item{chain}{The number of chain to be used in resultmcmc}

\item{series}{Names of the series to be analyzed or "all"}

\item{replicate.CI.mcmc}{Number of iterations to be used or "all"}

\item{replicate.CI}{Number of replicates for ML resampling}

\item{level}{Level to estimate confidence interval or credibility interval}

\item{print}{Should information be shown}

\item{...}{Not used}
}
\value{
A list with five objects: synthesis is a data.frame with global estimate of nesting.\cr
details_MCMC, details_ML, details_mean are lists with day by day information for each series, and
sum_synthesis is the synthesis of the sum of all analyzed time-series.
}
\description{
The function summary.phenology shows result and estimates confidence interval.\cr
If several years are analyzed, the sum_synthesis result can be obtained only if there is
not a mix of bisextile and non-bisextile years.
}
\details{
summary.phenology prints the information from a result object.
}
\examples{
\dontrun{
library(phenology)
# Read a file with data
data(Gratiot)
# Generate a formatted list nammed data_Gratiot 
data_Gratiot<-add_phenology(Gratiot, name="Complete", 
		reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, fixed.parameters=NULL)
# Run the optimisation
result_Gratiot<-fit_phenology(data=data_Gratiot, 
		fitted.parameters=parg, fixed.parameters=NULL)
data(result_Gratiot)
# Display information from the result
s <- summary(result_Gratiot)
# Using mcmc
s <- summary(object=result_Gratiot, resultmcmc=result_Gratiot_mcmc)
}
}
\seealso{
Other Phenology model: 
\code{\link{AutoFitPhenology}()},
\code{\link{BE_to_LBLE}()},
\code{\link{Gratiot}},
\code{\link{LBLE_to_BE}()},
\code{\link{LBLE_to_L}()},
\code{\link{L_to_LBLE}()},
\code{\link{MarineTurtles_2002}},
\code{\link{MinBMinE_to_Min}()},
\code{\link{adapt_parameters}()},
\code{\link{add_SE}()},
\code{\link{add_phenology}()},
\code{\link{extract_result}()},
\code{\link{fit_phenology}()},
\code{\link{likelihood_phenology}()},
\code{\link{logLik.phenology}()},
\code{\link{map_Gratiot}},
\code{\link{map_phenology}()},
\code{\link{par_init}()},
\code{\link{phenology}()},
\code{\link{phenology2fitRMU}()},
\code{\link{phenology_MHmcmc}()},
\code{\link{phenology_MHmcmc_p}()},
\code{\link{plot.phenology}()},
\code{\link{plot.phenologymap}()},
\code{\link{plot_delta}()},
\code{\link{plot_phi}()},
\code{\link{print.phenology}()},
\code{\link{print.phenologymap}()},
\code{\link{print.phenologyout}()},
\code{\link{remove_site}()},
\code{\link{result_Gratiot}},
\code{\link{result_Gratiot1}},
\code{\link{result_Gratiot2}},
\code{\link{result_Gratiot_Flat}},
\code{\link{result_Gratiot_mcmc}},
\code{\link{summary.phenologymap}()},
\code{\link{summary.phenologyout}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{Phenology model}
