% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhenoKl.R
\name{PhenoKl}
\alias{PhenoKl}
\title{Phenology extraction in Inflection method (Zhang)}
\usage{
PhenoKl(
  fFIT,
  t = NULL,
  analytical = FALSE,
  smoothed.spline = FALSE,
  IsPlot = TRUE,
  show.legend = TRUE,
  ...
)
}
\arguments{
\item{fFIT}{object return by \code{\link[=curvefit]{curvefit()}}}

\item{t}{\code{doy} vector, corresponding doy of vegetation index.}

\item{analytical}{If true, \code{numDeriv} package \code{grad} and \code{hess}
will be used; if false, \code{D1} and \code{D2} will be used.}

\item{smoothed.spline}{Whether apply \code{smooth.spline} first?}

\item{IsPlot}{whether to plot?}

\item{show.legend}{whether show figure lelend?}

\item{...}{Other parameters will be ignored.}
}
\value{
A numeric vector, with the elements of:
\code{Greenup}, \code{Maturity}, \code{Senescence}, \code{Dormancy}.
}
\description{
Phenology extraction in Inflection method (Zhang)
}
\examples{
# `doubleLog.Beck` simulate vegetation time-series
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
par  = c( mn  = 0.1 , mx  = 0.7 , sos = 50 , rsp = 0.1 , eos = 250, rau = 0.1)
y <- doubleLog.Beck(par, t)

methods <- c("AG", "Beck", "Elmore", "Gu", "Zhang") # "Klos" too slow
fit <- curvefit(y, t, tout, methods)
x <- fit$model$AG # one model

par(mfrow = c(2, 2))
PhenoTrs(x)
PhenoDeriv(x)
PhenoGu(x)
PhenoKl(x)
}
\references{
\enumerate{
\item Zhang, X., Friedl, M. A., Schaaf, C. B., Strahler, A. H., Hodges, J. C. F.
F., Gao, F., … Huete, A. (2003). Monitoring vegetation phenology using
MODIS. Remote Sensing of Environment, 84(3), 471–475.
\doi{10.1016/S0034-4257(02)00135-9}
}
}
