% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{run_modelsearch}
\alias{run_modelsearch}
\title{run_modelsearch}
\usage{
run_modelsearch(
  search_space,
  algorithm = "reduced_stepwise",
  iiv_strategy = "absorption_delay",
  rank_type = "bic",
  cutoff = NULL,
  results = NULL,
  model = NULL,
  strictness = "minimization_successful or (rounding_errors and sigdigs >= 0.1)",
  E = NULL,
  ...
)
}
\arguments{
\item{search_space}{(str or ModelFeatures) Search space to test. Either as a string or a ModelFeatures object.}

\item{algorithm}{(str) Algorithm to use.}

\item{iiv_strategy}{(str) If/how IIV should be added to candidate models. Default is 'absorption_delay'.}

\item{rank_type}{(str) Which ranking type should be used. Default is BIC.}

\item{cutoff}{(numeric (optional)) Cutoff for which value of the ranking function that is considered significant. Default
is NULL (all models will be ranked)}

\item{results}{(ModelfitResults (optional)) Results for model}

\item{model}{(Model (optional)) Pharmpy model}

\item{strictness}{(str (optional)) Strictness criteria}

\item{E}{(numeric or str (optional)) Expected number of predictors (used for mBIC). Must be set when using mBI}

\item{...}{Arguments to pass to tool}
}
\value{
(ModelSearchResults) Modelsearch tool result object
}
\description{
Run Modelsearch tool. For more details, see :ref:\code{modelsearch}.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
results <- load_example_modelfit_results("pheno")
run_modelsearch('ABSORPTION(ZO);PERIPHERALS(1)', 'exhaustive', results=results, model=model)
}

}
