% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{transform_blq}
\alias{transform_blq}
\title{transform_blq}
\usage{
transform_blq(model, method = "m4", lloq = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{method}{(str) Which BLQ method to use}

\item{lloq}{(numeric (optional)) LLOQ limit to use, if NULL Pharmpy will use the BLQ/LLOQ column in the dataset}
}
\value{
(Model) Pharmpy model object
}
\description{
Transform for BLQ data

Transform a given model, methods available are m1, m3, and m4 (1). Current limits of the
m3 and m4 method:
\itemize{
\item Does not support covariance between epsilons
\item Only supports additive, proportional, and combined error model
}

(1) Beal SL. Ways to fit a PK model with some data below the quantification
limit. J Pharmacokinet Pharmacodyn. 2001 Oct;28(5):481-504. doi: 10.1023/a:1012299115260.
Erratum in: J Pharmacokinet Pharmacodyn 2002 Jun;29(3):309. PMID: 11768292.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- transform_blq(model, method='m4', lloq=0.1)
model$statements$find_assignment("Y")
}
}
\seealso{
remove_loq_data
}
