% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{run_iivsearch}
\alias{run_iivsearch}
\title{run_iivsearch}
\usage{
run_iivsearch(
  algorithm,
  iiv_strategy = "no_add",
  rank_type = "bic",
  cutoff = NULL,
  results = NULL,
  model = NULL,
  ...
)
}
\arguments{
\item{algorithm}{(str) Which algorithm to run (brute_force, brute_force_no_of_etas, brute_force_block_structure)}

\item{iiv_strategy}{(str) If/how IIV should be added to start model. Possible strategies are 'no_add', 'add_diagonal',
or 'fullblock'. Default is 'no_add'}

\item{rank_type}{(str) Which ranking type should be used (OFV, AIC, BIC). Default is BIC}

\item{cutoff}{(numeric (optional)) Cutoff for which value of the ranking function that is considered significant. Default
is NULL (all models will be ranked)}

\item{results}{(ModelfitResults (optional)) Results for model}

\item{model}{(Model (optional)) Pharmpy mode}

\item{...}{Arguments to pass to tool}
}
\value{
(IIVSearchResults) IIVsearch tool result object
}
\description{
Run IIVsearch tool. For more details, see :ref:\code{iivsearch}.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
results <- load_example_modelfit_results("pheno")
run_iivsearch('brute_force', results=results, model=model)
}

}
