% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{set_proportional_error_model}
\alias{set_proportional_error_model}
\title{set_proportional_error_model}
\usage{
set_proportional_error_model(model, data_trans = NULL, zero_protection = FALSE)
}
\arguments{
\item{model}{(Model) Set error model for this model}

\item{data_trans}{(str or expression) A data transformation expression or NULL (default) to use the transformation
specified by the model.}

\item{zero_protection}{(logical) Set to TRUE to add code protecting from IPRED=0}
}
\value{
(Model) Reference to the same model object
}
\description{
Set a proportional error model. Initial estimate for new sigma is 0.09.

The error function being applied depends on the data transformation.

+------------------------+----------------------------------------+
| Data transformation    | Proportional error                     |
+========================+========================================+
| :math:\code{y}              | :math:\verb{f + f epsilon_1}               |
+------------------------+----------------------------------------+
| :math:\code{log(y)}         | :math:\code{log(f) + epsilon_1}           |
+------------------------+----------------------------------------+
}
\examples{
\dontrun{
model <- remove_error_model(load_example_model("pheno"))
set_proportional_error_model(model)
model$statements$find_assignment("Y")
model <- remove_error_model(load_example_model("pheno"))
set_proportional_error_model(model, data_trans="log(Y)", zero_protection=TRUE)
model$statements$after_odes
}
}
\seealso{
set_additive_error_model : Additive error model

set_combined_error_model : Combined error model
}
