# This file is automatically generated by data-raw/create_sdtms_data.R.
# For updating it please edit inst/extdata/sdtms-specs.json and rerun create_sdtms_data.R.
# Manual edits are not recommended, as changes may be overwritten.
#' Laboratory Measurements
#'
#' An updated SDTM LB dataset that uses data from the CDISC pilot project
#'
#' @name lb
#' @title Laboratory Measurements
#' @keywords dataset
#' @description An updated SDTM LB dataset that uses data from the CDISC pilot project
#' @docType data
#' @format A data frame with 23 columns:
#'   \describe{
#'     \item{STUDYID}{Study Identifier}
#'     \item{DOMAIN}{Domain Abbreviation}
#'     \item{USUBJID}{Unique Subject Identifier}
#'     \item{LBSEQ}{Sequence Number}
#'     \item{LBTESTCD}{Lab Test or Examination Short Name}
#'     \item{LBTEST}{Lab Test or Examination Name}
#'     \item{LBCAT}{Category for Lab Test}
#'     \item{LBORRES}{Result or Finding in Original Units}
#'     \item{LBORRESU}{Original Units}
#'     \item{LBORNRLO}{Reference Range Lower Limit in Orig Unit}
#'     \item{LBORNRHI}{Reference Range Upper Limit in Orig Unit}
#'     \item{LBSTRESC}{Character Result/Finding in Std Format}
#'     \item{LBSTRESN}{Numeric Result/Finding in Standard Units}
#'     \item{LBSTRESU}{Standard Units}
#'     \item{LBSTNRLO}{Reference Range Lower Limit-Std Units}
#'     \item{LBSTNRHI}{Reference Range Upper Limit-Std Units}
#'     \item{LBNRIND}{Reference Range Indicator}
#'     \item{LBBLFL}{Baseline Flag}
#'     \item{VISITNUM}{Visit Number}
#'     \item{VISIT}{Visit Name}
#'     \item{VISITDY}{Planned Study Day of Visit}
#'     \item{LBDTC}{Date/Time of Specimen Collection}
#'     \item{LBDY}{Study Day of Specimen Collection}
#'   }
#'
#' @source [Access the source of the Laboratory Measurements dataset.](https://github.com/pharmaverse/pharmaversesdtm/blob/main/data/lb.rda)
#' @author Annie Yang
#' @details Contains a set of 47 unique Test Short Names and Test Names: \tabular{ll}{
#'   \strong{LBTESTCD} \tab \strong{LBTEST} \cr
#'   ALB     \tab Albumin                                \cr
#'   ALP     \tab Alkaline Phosphatase                   \cr
#'   ALT     \tab Alanine Aminotransferase               \cr
#'   ANISO   \tab Anisocytes                             \cr
#'   AST     \tab Aspartate Aminotransferase             \cr
#'   BASO    \tab Basophils                              \cr
#'   BASOLE  \tab Basophils/Leukocytes                   \cr
#'   BILI    \tab Bilirubin                              \cr
#'   BUN     \tab Blood Urea Nitrogen                    \cr
#'   CA      \tab Calcium                                \cr
#'   CHOL    \tab Cholesterol                            \cr
#'   CK      \tab Creatine Kinase                        \cr
#'   CL      \tab Chloride                               \cr
#'   COLOR   \tab Color                                  \cr
#'   CREAT   \tab Creatinine                             \cr
#'   EOS     \tab Eosinophils                            \cr
#'   EOSLE   \tab Eosinophils/Leukocytes                 \cr
#'   GGT     \tab Gamma Glutamyl Transferase             \cr
#'   GLUC    \tab Glucose                                \cr
#'   HBA1C   \tab Hemoglobin A1C                         \cr
#'   HCT     \tab Hematocrit                             \cr
#'   HGB     \tab Hemoglobin                             \cr
#'   K       \tab Potassium                              \cr
#'   KETONES \tab Ketones                                \cr
#'   LYM     \tab Lymphocytes                            \cr
#'   LYMLE   \tab Lymphocytes/Leukocytes                 \cr
#'   MACROCY \tab Macrocytes                             \cr
#'   MCH     \tab Ery. Mean Corpuscular Hemoglobin       \cr
#'   MCHC    \tab Ery. Mean Corpuscular HGB Concentration\cr
#'   MCV     \tab Ery. Mean Corpuscular Volume           \cr
#'   MICROCY \tab Microcytes                             \cr
#'   MONO    \tab Monocytes                              \cr
#'   MONOLE  \tab Monocytes/Leukocytes                   \cr
#'   PH      \tab pH                                     \cr
#'   PHOS    \tab Phosphate                              \cr
#'   PLAT    \tab Platelet                               \cr
#'   POIKILO \tab Poikilocytes                           \cr
#'   POLYCHR \tab Polychromasia                          \cr
#'   PROT    \tab Protein                                \cr
#'   RBC     \tab Erythrocytes                           \cr
#'   SODIUM  \tab Sodium                                 \cr
#'   SPGRAV  \tab Specific Gravity                       \cr
#'   TSH     \tab Thyrotropin                            \cr
#'   URATE   \tab Urate                                  \cr
#'   UROBIL  \tab Urobilinogen                           \cr
#'   VITB12  \tab Vitamin B12                            \cr
#'   WBC     \tab Leukocytes
#' }

"lb"
