/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.functions;

import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.resources.functions.PSFunction;

public class ExponentialFunction
extends PSFunction {
    private double capN;
    private double[] c0;
    private double[] c1;

    public ExponentialFunction(PSObjectDict pSObjectDict) throws PSError {
        this.loadCommonEntries(pSObjectDict);
        this.capN = pSObjectDict.get("N").toReal();
        try {
            if (this.getNrOutputValues() >= 0) {
                this.c0 = pSObjectDict.get("C0").toArray().toDoubleArray(this.getNrOutputValues());
            } else {
                this.c0 = pSObjectDict.get("C0").toArray().toDoubleArray();
                this.setNrOutputValues(this.c0.length);
            }
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            this.c0 = new double[1];
            this.c0[0] = 0.0;
            this.setNrOutputValues(1);
        }
        try {
            this.c1 = pSObjectDict.get("C1").toArray().toDoubleArray(this.getNrOutputValues());
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            this.c1 = new double[1];
            this.c1[0] = 1.0;
        }
    }

    public double[] evaluate(double[] dArray) throws PSErrorRangeCheck, PSErrorUnimplemented {
        double[] dArray2 = this.evaluatePreProcess(dArray);
        double d = dArray2[0];
        double[] dArray3 = new double[this.getNrOutputValues()];
        for (int i = 0; i < this.getNrOutputValues(); ++i) {
            dArray3[i] = this.c0[i] + Math.pow(d, this.capN) * (this.c1[i] - this.c0[i]);
        }
        return this.evaluatePostProcess(dArray3);
    }
}

