/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.objects;

import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUndefinedResult;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectReal;

public class PSObjectMatrix
extends PSObjectArray {
    public PSObjectMatrix() {
        this(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public PSObjectMatrix(double d, double d2, double d3, double d4, double d5, double d6) {
        this.addAt(0, new PSObjectReal(d));
        this.addAt(1, new PSObjectReal(d2));
        this.addAt(2, new PSObjectReal(d3));
        this.addAt(3, new PSObjectReal(d4));
        this.addAt(4, new PSObjectReal(d5));
        this.addAt(5, new PSObjectReal(d6));
    }

    public PSObjectMatrix(PSObjectArray pSObjectArray) throws PSErrorRangeCheck, PSErrorTypeCheck {
        PSObjectMatrix.checkMatrix(pSObjectArray);
        this.setArray(pSObjectArray.getArray());
        this.setOffset(pSObjectArray.getOffset());
        this.setCount(pSObjectArray.getCount());
        this.copyCommonAttributes(pSObjectArray);
    }

    public static void checkMatrix(PSObjectArray pSObjectArray) throws PSErrorRangeCheck {
        if (pSObjectArray.size() != 6) {
            throw new PSErrorRangeCheck();
        }
    }

    public PSObjectMatrix clone() {
        PSObjectMatrix pSObjectMatrix = (PSObjectMatrix)super.clone();
        return pSObjectMatrix;
    }

    public void concat(PSObjectMatrix pSObjectMatrix) throws PSErrorRangeCheck, PSErrorTypeCheck {
        double d = pSObjectMatrix.getReal(0) * this.getReal(0) + pSObjectMatrix.getReal(1) * this.getReal(2);
        double d2 = pSObjectMatrix.getReal(0) * this.getReal(1) + pSObjectMatrix.getReal(1) * this.getReal(3);
        double d3 = pSObjectMatrix.getReal(2) * this.getReal(0) + pSObjectMatrix.getReal(3) * this.getReal(2);
        double d4 = pSObjectMatrix.getReal(2) * this.getReal(1) + pSObjectMatrix.getReal(3) * this.getReal(3);
        double d5 = pSObjectMatrix.getReal(4) * this.getReal(0) + pSObjectMatrix.getReal(5) * this.getReal(2) + this.getReal(4);
        double d6 = pSObjectMatrix.getReal(4) * this.getReal(1) + pSObjectMatrix.getReal(5) * this.getReal(3) + this.getReal(5);
        this.setReal(0, d);
        this.setReal(1, d2);
        this.setReal(2, d3);
        this.setReal(3, d4);
        this.setReal(4, d5);
        this.setReal(5, d6);
    }

    public double[] dtransform(double d, double d2) throws PSErrorRangeCheck, PSErrorTypeCheck {
        double[] dArray = new double[]{this.getReal(0) * d + this.getReal(2) * d2, this.getReal(1) * d + this.getReal(3) * d2};
        return dArray;
    }

    public PSObjectMatrix dup() {
        try {
            return new PSObjectMatrix(this);
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            return null;
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            return null;
        }
    }

    public double getMeanScaling() throws PSErrorRangeCheck, PSErrorTypeCheck {
        return 0.5 * (this.getXScaling() + this.getYScaling());
    }

    public double getRotation() throws PSErrorRangeCheck, PSErrorTypeCheck {
        return Math.atan2(this.getReal(1), this.getReal(0)) / Math.PI * 180.0;
    }

    public double getXScaling() throws PSErrorRangeCheck, PSErrorTypeCheck {
        return Math.sqrt(Math.pow(this.getReal(0), 2.0) + Math.pow(this.getReal(2), 2.0));
    }

    public double getYScaling() throws PSErrorRangeCheck, PSErrorTypeCheck {
        return Math.sqrt(Math.pow(this.getReal(1), 2.0) + Math.pow(this.getReal(3), 2.0));
    }

    public double[] idtransform(double d, double d2) throws PSErrorRangeCheck, PSErrorTypeCheck {
        double d3 = this.getReal(0);
        double d4 = this.getReal(1);
        double d5 = this.getReal(2);
        double d6 = this.getReal(3);
        double[] dArray = new double[]{(d6 * d - d5 * d2) / (-d5 * d4 + d3 * d6), -(-d3 * d2 + d4 * d) / (-d5 * d4 + d3 * d6)};
        return dArray;
    }

    public double[] idtransform(double[] dArray) throws PSErrorRangeCheck, PSErrorTypeCheck {
        return this.idtransform(dArray[0], dArray[1]);
    }

    public void invert() throws PSErrorUndefinedResult, PSErrorRangeCheck, PSErrorTypeCheck {
        double d = this.getReal(0);
        double d2 = this.getReal(1);
        double d3 = this.getReal(2);
        double d4 = this.getReal(3);
        double d5 = this.getReal(4);
        double d6 = this.getReal(5);
        double d7 = 1.0 / (d * d4 - d3 * d2);
        if (Double.isInfinite(d7) || Double.isNaN(d7)) {
            throw new PSErrorUndefinedResult();
        }
        this.setReal(0, d4 * d7);
        this.setReal(1, -d2 * d7);
        this.setReal(2, -d3 * d7);
        this.setReal(3, d * d7);
        this.setReal(4, (d3 * d6 - d4 * d5) * d7);
        this.setReal(5, -(d * d6 - d2 * d5) * d7);
    }

    public double[] itransform(double d, double d2) throws PSErrorRangeCheck, PSErrorTypeCheck {
        double d3 = this.getReal(0);
        double d4 = this.getReal(1);
        double d5 = this.getReal(2);
        double d6 = this.getReal(3);
        double d7 = this.getReal(4);
        double d8 = this.getReal(5);
        double[] dArray = new double[]{(d6 * d - d5 * d2 + d5 * d8 - d6 * d7) / (-d5 * d4 + d3 * d6), -(-d3 * d2 - d4 * d7 + d3 * d8 + d4 * d) / (-d5 * d4 + d3 * d6)};
        return dArray;
    }

    public double[] itransform(double[] dArray) throws PSErrorRangeCheck, PSErrorTypeCheck {
        return this.itransform(dArray[0], dArray[1]);
    }

    public void rotate(double d) throws PSErrorRangeCheck, PSErrorTypeCheck {
        double d2 = Math.cos(d * Math.PI / 180.0);
        double d3 = Math.sin(d * Math.PI / 180.0);
        double d4 = d2 * this.getReal(0) + d3 * this.getReal(2);
        double d5 = d2 * this.getReal(1) + d3 * this.getReal(3);
        double d6 = -d3 * this.getReal(0) + d2 * this.getReal(2);
        double d7 = -d3 * this.getReal(1) + d2 * this.getReal(3);
        this.setReal(0, d4);
        this.setReal(1, d5);
        this.setReal(2, d6);
        this.setReal(3, d7);
    }

    public void scale(double d, double d2) throws PSErrorRangeCheck, PSErrorTypeCheck {
        this.setReal(0, d * this.getReal(0));
        this.setReal(1, d * this.getReal(1));
        this.setReal(2, d2 * this.getReal(2));
        this.setReal(3, d2 * this.getReal(3));
    }

    public PSObjectMatrix toMatrix() {
        return this;
    }

    public double[] transform(double[] dArray) throws PSErrorRangeCheck, PSErrorTypeCheck {
        return this.transform(dArray[0], dArray[1]);
    }

    public double[] transform(double d, double d2) throws PSErrorRangeCheck, PSErrorTypeCheck {
        double[] dArray = new double[]{this.getReal(0) * d + this.getReal(2) * d2 + this.getReal(4), this.getReal(1) * d + this.getReal(3) * d2 + this.getReal(5)};
        return dArray;
    }

    public void translate(double d, double d2) throws PSErrorRangeCheck, PSErrorTypeCheck {
        this.setReal(4, d * this.getReal(0) + d2 * this.getReal(2) + this.getReal(4));
        this.setReal(5, d * this.getReal(1) + d2 * this.getReal(3) + this.getReal(5));
    }
}

