% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attenuationCorrelation.R
\name{attenuationCorrelation}
\alias{attenuationCorrelation}
\title{Attenuation of True Correlation Due to Measurement Error.}
\usage{
attenuationCorrelation(
  trueAssociation,
  reliabilityOfPredictor,
  reliabilityOfCriterion
)
}
\arguments{
\item{trueAssociation}{Magnitude of true association (\emph{r} value).}

\item{reliabilityOfPredictor}{Reliability of predictor (from 0 to 1).}

\item{reliabilityOfCriterion}{Reliability of criterion/outcome (from 0 to 1).}
}
\value{
Observed correlation between predictor and criterion.
}
\description{
Estimate the observed association between the predictor and criterion after
accounting for the degree to which a true correlation is attenuated due to
measurement error.
}
\details{
Estimate the association that would be observed between the predictor and
criterion after accounting for the degree to which a true correlation is
attenuated due to random measurement error (unreliability).
}
\examples{
attenuationCorrelation(
  trueAssociation = .7,
  reliabilityOfPredictor = .9,
  reliabilityOfCriterion = .85)
}
\seealso{
Other correlation: 
\code{\link{disattenuationCorrelation}()}
}
\concept{correlation}
