% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_accessors.R
\name{relabel}
\alias{relabel}
\alias{labels.ped}
\alias{labels.list}
\title{Get or modify pedigree labels}
\usage{
relabel(
  x,
  new = "asPlot",
  old = labels(x),
  reorder = FALSE,
  returnLabs = FALSE,
  .alignment = NULL
)

\method{labels}{ped}(object, ...)

\method{labels}{list}(object, ...)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{new}{Either a character vector containing new labels, or one of the
special words "asPlot" (default) or "generations". See Details and
Examples.}

\item{old}{A vector of ID labels, of the same length as \code{new}. (Ignored if
\code{new} is one of the special words.)}

\item{reorder}{A logical. If TRUE, \code{\link[=reorderPed]{reorderPed()}} is called on \code{x} after
relabelling. Default: FALSE.}

\item{returnLabs}{A logical. If TRUE, the new labels are returned as a named
character vector.}

\item{.alignment}{A list of alignment details for \code{x}, used if \code{new} equals
"asPlot" or "generations". If not supplied, this is computed internally
with \code{\link[=.pedAlignment]{.pedAlignment()}}.}

\item{object}{A \code{ped} object}

\item{...}{Not used}
}
\value{
\itemize{
\item \code{labels()} returns a character vector containing the ID labels of all
pedigree members. If the input is a list of ped objects, the output is a list
of character vectors.
\item \code{relabel()} by default returns a \code{ped} object similar to \code{x}, but with
modified labels. If \code{returnLabs} is TRUE, the new labels are returned as a
named character vector
}
}
\description{
Functions for getting or changing the ID labels of pedigree members.
}
\details{
By default, \code{relabel(x)} relabels everyone as 1, 2, ..., in the order given
by the plot (top to bottom; left to right).

Alternatively, \code{relabel(x, "generations")} labels the members in the top
generation I-1, I-2, ..., in the second generation II-1, II-2, ..., etc.
}
\examples{

x = nuclearPed()
x
labels(x)

y = relabel(x, new = "girl", old = 3)
y

# Back to the numeric labels
z = relabel(y)
stopifnot(identical(x,z))

# Generation labels
relabel(x, "generations")

}
\seealso{
\code{\link[=ped]{ped()}}
}
