% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomPed.R
\name{randomPed}
\alias{randomPed}
\title{Random pedigree}
\usage{
randomPed(n, f = 2, selfing = FALSE, seed = NULL, g = NULL, founders = NULL)
}
\arguments{
\item{n}{A positive integer: the total number of individuals. Must be at
least 3.}

\item{f}{A positive integer: the number of founders. Must be at least 2
unless selfing is allowed.}

\item{selfing}{A logical indicating if selfing is allowed. Default: FALSE.}

\item{seed}{An integer seed for the random number generator (optional).}

\item{g, founders}{Deprecated arguments.}
}
\value{
A connected pedigree returned as a \code{ped} object.
}
\description{
Generate a random connected pedigree by applying random mating starting from
a finite population.
}
\details{
Starting from an initial set of \code{f} singletons, a sequence of \code{n-f} random
matings is performed. The sampling of parents in each mating is set up to
ensure that the final result is connected.
}
\examples{
randomPed(8, f = 3, seed = 11)
randomPed(8, f = 3, seed = 11, selfing = TRUE)

}
